import {db,executeQuery} from "../config/database.js";

async function InserirDestaque(req,res,next){
    let erros = [];

    !req.body.destaque && erros.push("Nome do destaque não informada");
    !req.body.ativo && erros.push("Status não informado");

    if(req.body.destaque){
        let destaque = await executeQuery(db,"SELECT descricao FROM destaques WHERE descricao = ?", [req.body.destaque]);

        destaque.length > 0 && erros.push("Destaque já está em uso!");
    }

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}


export default {InserirDestaque}