import {db,executeQuery} from "../config/database.js";

function Login(req,res,next){
    let erros = [];

    !req.body.email && erros.push("Email não informado");
    !req.body.senha && erros.push("Senha não informada");

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

async function Inserir(req,res,next){
    let erros = [];

    !req.body.razao && erros.push("Nome não informado");
    !req.body.email && erros.push("Email não informado");
    !req.body.senha && erros.push("Senha não informada");
    !req.body.endereco && erros.push("Endereço não informado");
    !req.body.bairro && erros.push("Bairro não informado");
    !req.body.cidade && erros.push("Cidade não informado");
    !req.body.uf && erros.push("UF não informado");
    !req.body.cep && erros.push("CEP não informado");
    !req.body.ibge && erros.push("Cód. Cidade não informado");
    !req.body.telefone && erros.push("Celular não informado");
    !req.body.cnpj && erros.push("CPF não informado");

    if(req.body.cnpj){
        let cpfExiste = await executeQuery(db,"SELECT cpfcnpj FROM clientes WHERE cpfcnpj = ?", [req.body.cnpj]);
        cpfExiste.length > 0 && erros.push("CPF já está em uso!");
    }

    if(req.body.email){
        let emailExiste = await executeQuery(db,"SELECT email FROM clientes WHERE email = ?", [req.body.email]);

        emailExiste.length > 0 && erros.push("Email já está em uso!");
    }

    

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

function InserirEndereco(req,res,next){
    let erros = [];

    !req.body.endereco && erros.push("Endereço não informado");
    !req.body.bairro && erros.push("Bairro não informado");
    !req.body.cidade && erros.push("Cidade não informado");
    !req.body.uf && erros.push("UF não informado");
    !req.body.cep && erros.push("CEP não informado");
    !req.body.ibge && erros.push("Cód. Cidade não informado");

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

function Endereco(req,res,next){
    let erros = [];

    !req.params.ibge && erros.push("Código do endereço não informado");    

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

export default {Login,Inserir, InserirEndereco,Endereco}