import {db,executeQuery} from "../config/database.js";

function Login(req,res,next){
    let erros = [];

    !req.body.email && erros.push("Email não informado");
    !req.body.senha && erros.push("Senha não informada");

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

async function InserirProfissional(req,res,next){
    let erros = [];

    !req.body.nome && erros.push("Nome do profissional não informado");
    !req.body.celular && erros.push("Celular do profissional não informado");
    !req.body.servico && erros.push("Serviço não informado");
    !req.body.email && erros.push("Email não informado");
    !req.body.senha && erros.push("Senha não informado");
    !req.body.regiao_servico && erros.push("Região de serviço não informado");
    !req.body.foto && erros.push("Foto não informado");

    if(req.body.nome){
        let nome = await executeQuery(db,"SELECT nome FROM profissionais WHERE nome = ?", [req.body.nome]);

        nome.length > 0 && erros.push("Profissional já está em uso!");
    }

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

export default {Login,InserirProfissional}