import {db,executeQuery} from "../config/database.js";

async function InserirUnidade(req,res,next){
    let erros = [];

    !req.body.unidade && erros.push("Nome da unidade não informada");
    !req.body.sigla && erros.push("Sigla da unidade não informada");

    if(req.body.unidade){
        let unidade = await executeQuery(db,"SELECT unidade FROM unidades WHERE unidade = ?", [req.body.unidade]);

        unidade.length > 0 && erros.push("Unidade já está em uso!");
    }

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

async function InserirProduto(req,res,next){
    let erros = [];

    !req.body.id_empresa && erros.push("Código da empresa não informada");
    !req.body.id_departamento && erros.push("Departamento do produto não informada");
    !req.body.id_unidade && erros.push("Unidade não informado");
    !req.body.descricao && erros.push("Descrição não informado");
    !req.body.produto && erros.push("Nome do produto não informado");
    !req.body.venda && erros.push("Preço de venda não informado");
    !req.body.custo && erros.push("Preço de custo não informado");
    !req.body.estoque && erros.push("Quantidade em estoque não informado");
    !req.body.min && erros.push("Quantidade minima em estoque não informado");
    !req.body.max && erros.push("Quantidade máxima em estoque não informado");
    !req.body.validade && erros.push("Data de validade não informado");
    !req.body.marca && erros.push("Marca não informado");
    !req.body.fornecedor && erros.push("Fornecedor não informado");
    !req.body.variacao && erros.push("Variações do produto não informado");

    if(req.body.produto){
        let produto = await executeQuery(db,"SELECT produto FROM produtos WHERE produto = ? AND id_empresa = ?", [req.body.produto, req.body.id_empresa]);

        produto.length > 0 && erros.push("Produto já está em uso!");
    }

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

function ListarProdutos(req,res,next){
    let erros = [];

    !req.query.cidade && erros.push("Cidade não informada");
    //!req.query.pagina && erros.push("Número da página não informada");

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

export default {InserirUnidade,InserirProduto,ListarProdutos}