import {db,executeQuery} from "../config/database.js";

async function Inserir(req,res,next){
    let erros = [];

    !req.body.id_empresa && erros.push("Código da empresa não informada");
    !req.body.marca && erros.push("Nome da Marca não informada");
    !req.body.ativo && erros.push("Status não informado");

    if(req.body.marca){
        let marca = await executeQuery(db,"SELECT marca FROM marcas WHERE marca = ? AND id_empresa = ?", [req.body.marca, req.body.id_empresa]);

        marca.length > 0 && erros.push("Marca já está em uso!");
    }

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

function Listar(req,res,next){
    let erros = [];

    !req.query.pagina && erros.push("Número da página não informada");

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

export default {Inserir,Listar}