import {db,executeQuery} from "../config/database.js";

async function Inserir(req,res,next){
    let erros = [];

    !req.body.razao_social && erros.push("Razão Social não informada");
    !req.body.id_empresa && erros.push("Código da empresa não informada");
    !req.body.fantasia && erros.push("Nome Fantasia não informado");
    !req.body.tipo && erros.push("Tipo de empresa não informado");
    !req.body.cnpj && erros.push("CNPJ não informado");
    !req.body.inscricao_estadual && erros.push("IE não informado");
    !req.body.inscricao_municipal && erros.push("IM não informado");
    !req.body.email && erros.push("Email não informado");
    !req.body.ativo && erros.push("Status não informado");
    !req.body.cep && erros.push("CEP não informado");
    !req.body.endereco && erros.push("Endereço não informado");
    !req.body.numero && erros.push("Número não informado");
    !req.body.bairro && erros.push("Bairro não informado");
    !req.body.ibge && erros.push("Código da Cidade não informado");
    !req.body.cidade && erros.push("Cidade não informado");
    !req.body.uf && erros.push("UF não informado");


    if(req.body.fantasia){
        let fantasia = await executeQuery(db,"SELECT fantasia FROM fornecedores WHERE fantasia = ? AND id_empresa = ?", [req.body.departamento, req.body.id_empresa]);

        fantasia.length > 0 && erros.push("Fornecedor já está em uso!");
    }

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

function Listar(req,res,next){
    let erros = [];

    !req.query.pagina && erros.push("Número da página não informada");

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

export default {Inserir,Listar}