import {db,executeQuery} from "../config/database.js";

function LoginEntregador(req,res,next){
    let erros = [];

    !req.body.email && erros.push("Email não informado");
    !req.body.senha && erros.push("Senha não informada");

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

async function InserirEntregador(req,res,next){
    let erros = [];

    !req.body.nome && erros.push("Nome não informado");
    !req.body.cpf && erros.push("CPF não informado");
    !req.body.modalidade_entrega && erros.push("Modalidade de entrega não informado");
    !req.body.foto && erros.push("Foto não informada");
    !req.body.foto_documento && erros.push("Foto do documento não informado");
    !req.body.celular && erros.push("Celular não informado");
    !req.body.regiao_atendimento && erros.push("Região de atendimento não informado");
    !req.body.cep && erros.push("CEP não informado");
    !req.body.endereco && erros.push("Endereço informado");
    !req.body.numero && erros.push("Número não informada");
    !req.body.bairro && erros.push("Bairro não informado");
    !req.body.ibge && erros.push("Código da Cidade não informado");
    !req.body.cidade && erros.push("Cidade não informado");
    !req.body.uf && erros.push("UF não informado");
    !req.body.email && erros.push("Eamil não informado");
    !req.body.senha && erros.push("Senha não informada");
    !req.body.placa && erros.push("Placa do Veículo não informada");
    !req.body.marca && erros.push("Marca do veículo não informada");
    !req.body.modelo && erros.push("Modelo do Veículo não informado");
    !req.body.ano && erros.push("Ano do Veículo não informado");

    if(req.body.email){
        let emailExiste = await executeQuery(db,"SELECT email FROM entregadores WHERE email = ?", [req.body.email]);

        emailExiste.length > 0 && erros.push("Email já está em uso!");
    }

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

export default {LoginEntregador,InserirEntregador}