import {db,executeQuery} from "../config/database.js";

function Login(req,res,next){
    let erros = [];

    !req.body.email && erros.push("Email não informado");
    !req.body.senha && erros.push("Senha não informada");

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

async function InserirEmpresa(req,res,next){
    let erros = [];

    !req.body.razao_social && erros.push("Razão Social não informada");
    !req.body.fantasia && erros.push("Fantasia não informada");
    !req.body.cnpj && erros.push("CNPJ não informado");
    !req.body.inscricao_estadual && erros.push("Inscrição Estadual não informado");
    !req.body.cep && erros.push("CEP não informado");
    !req.body.endereco && erros.push("Endereço não informado");
    !req.body.numero && erros.push("Número não informado");
    !req.body.bairro && erros.push("Bairro não informado");
    !req.body.ibge && erros.push("Cód da Cidade não informado");
    !req.body.cidade && erros.push("Cidade não informada");
    !req.body.uf && erros.push("CeluUFlar não informado");
    !req.body.telefone && erros.push("Telefone não informado");
    !req.body.site && erros.push("site não informado");
    !req.body.email && erros.push("Email não informado");
    !req.body.senha && erros.push("Senha não informada");
    !req.body.matriz_filial && erros.push("Matriz não informado");
    !req.body.logo && erros.push("logo não informada");
    !req.body.cnae && erros.push("CNAE não informada");
    !req.body.departamentos && erros.push("Departamento não informado");

    if(req.body.email){
        let emailExiste = await executeQuery(db,"SELECT email FROM empresas WHERE email = ?", [req.body.email]);

        emailExiste.length > 0 && erros.push("Email já está em uso!");
    }

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

export default {Login,InserirEmpresa}