import {db,executeQuery} from "../config/database.js";

async function Inserir(req,res,next){
    let erros = [];

    !req.body.departamento && erros.push("Nome do departamento não informada");
    !req.body.foto && erros.push("Foto do departamento não informado");

    if(req.body.departamento){
        let departamento = await executeQuery(db,"SELECT departamento FROM departamentos WHERE departamento = ?", [req.body.departamento]);

        departamento.length > 0 && erros.push("Departamento já está em uso!");
    }

    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

function Listar(req,res,next){
    let erros = [];


    if(erros.length > 0){
        return res.status(400).json({erro: erros.join(", ")})
    }else{
        next();
    }
}

export default {Inserir,Listar}