import { Router } from "express";
import controllerProfissional from "../controllers/controller.profissional.js";
import {verifyJWT} from "../config/token.js";
import validadeProfissional from "../validation/validade.profissional.js";

const routeProfissional = Router();


routeProfissional.post("/v1/profissionais/registro", validadeProfissional.InserirProfissional, controllerProfissional.InserirProfissional);

routeProfissional.post("/v1/profissionais/login", validadeProfissional.Login, controllerProfissional.LoginProfissional);

routeProfissional.get("/v1/profissionais/", controllerProfissional.ListarProfissional);

routeProfissional.put("/v1/profissionais/", verifyJWT, controllerProfissional.EditarProfissional);

routeProfissional.put("/v1/profissionais/senha", verifyJWT, controllerProfissional.EditarSenha);

routeProfissional.post("/v1/profissionais/vitrine/registro", controllerProfissional.InserirVitrine);

routeProfissional.get("/v1/profissionais/vitrine/:id_profissional", controllerProfissional.ListarVitrine);

routeProfissional.get("/v1/profissionais/servicos", controllerProfissional.ListarServicos);

export default routeProfissional;