import { Router } from "express";
import controllerProduto from "../controllers/controller.produto.js";
import {verifyJWT} from "../config/token.js";
import validadeProdutos from "../validation/validade.produtos.js";

const routeProduto = Router();


routeProduto.post("/v1/produtos/unidades", [validadeProdutos.InserirUnidade,verifyJWT], controllerProduto.InserirUnidades);

routeProduto.get("/v1/produtos/unidades", verifyJWT, controllerProduto.ListarUnidades);

routeProduto.put("/v1/produtos/unidades/:id_unidade", verifyJWT, controllerProduto.AtualizarUnidades);

//ROTAS DE PRODUTOS
routeProduto.post("/v1/produtos",[validadeProdutos.InserirProduto,verifyJWT],controllerProduto.InserirProduto);

routeProduto.get("/v1/produtos",[validadeProdutos.ListarProdutos,verifyJWT],controllerProduto.ListarProduto);

routeProduto.put("/v1/produtos/:id_produto",verifyJWT,controllerProduto.AtualizarProduto);

routeProduto.get("/v1/variacoes",verifyJWT,controllerProduto.ListarVariacoes);

routeProduto.post("/v1/produtos/variacoes", verifyJWT, controllerProduto.InserirTipoVariacao);

routeProduto.get("/v1/produtos/variacoes/tipo",verifyJWT, controllerProduto.ListarTipoVariacoes);

routeProduto.get("/v1/produtos/maisvendidos/:id_empresa/:periodo",controllerProduto.ListarmaisVendidos);

export default routeProduto;