import { Router } from "express";
import controllerPedidos from "../controllers/controller.pedidos.js";
import {verifyJWT} from "../config/token.js";
import validadePedidos from "../validation/validade.pedidos.js";

const routePedidos = Router();

routePedidos.post("/v1/pedidos", [validadePedidos.Inserir,verifyJWT], controllerPedidos.Inserir);

routePedidos.get("/v1/pedidos", verifyJWT, controllerPedidos.Listar);

routePedidos.get("/v1/pedidos/empresa", verifyJWT, controllerPedidos.ListarPedidoEmpresa);

routePedidos.get("/v1/pedidos/itens/:id_pedido", verifyJWT, controllerPedidos.ListarItens);

routePedidos.put("/v1/pedidos/:id_pedido", verifyJWT, controllerPedidos.AtualizarStatus);

routePedidos.put("/v1/pedidos/cancelamento/:id_pedido", verifyJWT, controllerPedidos.AtualizarStatusCancelamento);

routePedidos.put("/v1/pedidos/avaliacao/:id_pedido", verifyJWT, controllerPedidos.AvaliarPedido);

routePedidos.put("/v1/pedidos/avaliacao/item/:id_item", verifyJWT, controllerPedidos.AvaliarItens);

routePedidos.get("/v1/pedidos/empresa/:id_pedido", verifyJWT, controllerPedidos.ListarPedidoCliente);

routePedidos.post("/v1/pedidos/entregador/:id_pedido", verifyJWT, controllerPedidos.AtribuirEntregador);

routePedidos.get("/v1/pedidos/entregador/:id_pedido", verifyJWT, controllerPedidos.ListarPedidoEntregador);

routePedidos.get("/v1/pedidos/recentes", verifyJWT, controllerPedidos.ListarPedidosRecentes);

routePedidos.get("/v1/pedidos/listar", verifyJWT,controllerPedidos.ListarVendas);

routePedidos.get("/v1/pedidos/clientes", verifyJWT,controllerPedidos.ListarClientes);

routePedidos.post("/v1/notificacao/registro", controllerPedidos.NotificacaoEmpresa);

routePedidos.get("/v1/notificacao", controllerPedidos.NotificacaoMostrar);

export default routePedidos;