import { Router } from "express";
import controllerMarca from "../controllers/controller.marca.js";
import {verifyJWT} from "../config/token.js";
import validadeMarca from "../validation/validade.marca.js";

const routeMarca = Router();


routeMarca.post("/v1/marcas", [validadeMarca.Inserir,verifyJWT], controllerMarca.InserirMarca);

routeMarca.get("/v1/marcas", [validadeMarca.Listar,verifyJWT], controllerMarca.ListarMarca);

routeMarca.put("/v1/marcas/:id_marca", verifyJWT, controllerMarca.AtualizarMarca);

routeMarca.get("/v1/marcas/:id_marca", verifyJWT, controllerMarca.BuscarMarca);

export default routeMarca;