import { Router } from "express";
import controllerFornecedor from "../controllers/controller.fornecedor.js";
import {verifyJWT} from "../config/token.js";
import validadeFornecedor from "../validation/validade.fornecedor.js";

const routeFornecedor = Router();


routeFornecedor.post("/v1/fornecedores", [validadeFornecedor.Inserir,verifyJWT], controllerFornecedor.InserirFornecedor);

routeFornecedor.get("/v1/fornecedores", [validadeFornecedor.Listar,verifyJWT], controllerFornecedor.ListarFornecedor);

routeFornecedor.put("/v1/fornecedores/:id_fornecedor", verifyJWT, controllerFornecedor.AtualizarFornecedor);

routeFornecedor.get("/v1/fornecedores/:id_fornecedor", verifyJWT, controllerFornecedor.BuscarFornecedor);

export default routeFornecedor;