import { Router } from "express";
import controllerEntregador from "../controllers/controller.entregador.js";
import {verifyJWT} from "../config/token.js";
import validadeEntregador from "../validation/validade.entregador.js";

const routeEntregador = Router();


routeEntregador.post("/v1/entregador/registro", validadeEntregador.InserirEntregador, controllerEntregador.InserirEntregador);

routeEntregador.post("/v1/entregador/login",validadeEntregador.LoginEntregador, controllerEntregador.LoginEntregador);

routeEntregador.get("/v1/entregador/modalidade",controllerEntregador.ListarModalidade);

routeEntregador.get("/v1/entregador/:id_entregador", verifyJWT, controllerEntregador.ListarID);

routeEntregador.put("/v1/entregador/", verifyJWT, controllerEntregador.EditarEntregador);

routeEntregador.put("/v1/entregador/foto", verifyJWT, controllerEntregador.EditarFoto);

routeEntregador.put("/v1/entregador/veiculo", verifyJWT, controllerEntregador.EditarVeiculo);

routeEntregador.put("/v1/entregador/senha", verifyJWT, controllerEntregador.EditarSenha);

routeEntregador.get("/v1/entregador/pedido/:id_pedido", verifyJWT, controllerEntregador.ListarPedidoEntrega);

routeEntregador.post("/v1/entregador/pedido/:id_pedido",controllerEntregador.InserirPedidoEntrega);

routeEntregador.put("/v1/entregador/pedido/:id_pedido",controllerEntregador.AtualizarPedidoEntregaEntregador);

routeEntregador.put("/v1/entregador/coordenadas/:id_pedido",controllerEntregador.AtualizarCoordenadas);


export default routeEntregador;