import { Router } from "express";
import controllerEntrega from "../controllers/controller.entrega.js";
import {verifyJWT} from "../config/token.js";
import validadeEntrega from "../validation/validade.entrega.js";

const routeEntrega = Router();


routeEntrega.post("/v1/entregas/", validadeEntrega.InserirEntrega, controllerEntrega.InserirEntrega);

routeEntrega.get("/v1/entregas/:id_entregador", verifyJWT, controllerEntrega.ListarID);

routeEntrega.put("/v1/entregas/:id_entrega", verifyJWT, controllerEntrega.EditarStatus);

export default routeEntrega;