import { Router } from "express";
import controllerEmpresa from "../controllers/controller.empresa.js";
import {verifyJWT} from "../config/token.js";
import validadeEmpresa from "../validation/validade.empresa.js";

const routeEmpresa = Router();


routeEmpresa.post("/v1/empresas/registro", validadeEmpresa.InserirEmpresa, controllerEmpresa.InserirEmpresa);

routeEmpresa.post("/v1/empresas/login", validadeEmpresa.Login, controllerEmpresa.LoginEmpresa);

routeEmpresa.put("/v1/empresas/:id_empresa", verifyJWT, controllerEmpresa.AtualizaEmpresaEmpresa);

routeEmpresa.get("/v1/empresas/favoritos", verifyJWT, controllerEmpresa.ListarFavoritos);

routeEmpresa.post("/v1/empresas/favoritos", verifyJWT, controllerEmpresa.InserirFavorito);

routeEmpresa.delete("/v1/empresas/favoritos/:id_favorito", verifyJWT, controllerEmpresa.ExcluirFavorito);

routeEmpresa.get("/v1/empresas",verifyJWT,controllerEmpresa.ListarEmpresa);

routeEmpresa.get("/v1/empresas/favoritas",verifyJWT,controllerEmpresa.ListarEmpresaFvoritas);

routeEmpresa.post("/v1/empresas/interesses",controllerEmpresa.InserirInteresse);

routeEmpresa.get("/v1/empresas/cnae",controllerEmpresa.BuscarCNAE);

export default routeEmpresa;