import { Router } from "express";
import controllerDestaque from "../controllers/controller.destaque.js";
import {verifyJWT} from "../config/token.js";
import validateDestaque from "../validation/validate.destaque.js";

const routeDestaque = Router();

routeDestaque.post("/v1/destaque/empresas/registro", verifyJWT, controllerDestaque.InserirEmpresaDestaque);

routeDestaque.put("/v1/destaques/empresas/:id_destaque", verifyJWT, controllerDestaque.AtualizarEmpresaDestaque);

routeDestaque.post("/v1/destaque/registro", [verifyJWT, validateDestaque.InserirDestaque], controllerDestaque.InserirDestaque);

routeDestaque.get("/v1/destaques/empresa", verifyJWT, controllerDestaque.ListarDestaquesEmpresa);

routeDestaque.get("/v1/destaques", verifyJWT, controllerDestaque.ListarDestaques);

routeDestaque.put("/v1/destaques/:id_destaque", verifyJWT, controllerDestaque.AtualizarDestaque);

export default routeDestaque;