import { Router } from "express";
import controllerDepartamento from "../controllers/controller.departamento.js";
import validadeDepartamento from "../validation/validade.departamento.js";

const routeDepartamento = Router();


routeDepartamento.post("/v1/departamentos/registro", validadeDepartamento.Inserir, controllerDepartamento.InserirDepartamento);

routeDepartamento.get("/v1/departamentos", validadeDepartamento.Listar, controllerDepartamento.Listar);

routeDepartamento.put("/v1/departamentos/:id_departamento", controllerDepartamento.AtualizaDepartamento);

// routeDepartamento.put("/v1/empresas", verifyJWT, controllerEmpresa.AtualizaEmpresaEmpresa);

// routeDepartamento.post("/v1/empresas/favoritos", verifyJWT, controllerEmpresa.InserirFavorito);

// routeDepartamento.delete("/v1/empresas/favoritos/:id_favorito", verifyJWT, controllerEmpresa.ExcluirFavorito);


export default routeDepartamento;