import { Router } from "express";
import controllerCliente from "../controllers/controller.cliente.js";
import validate from "../validation/validate.cliente.js";
import {verifyJWT} from "../config/token.js";

const routeUsuario = Router();

//ENDEREÇOS

routeUsuario.get("/v1/usuarios/enderecos", verifyJWT, controllerCliente.ListarEnderecos);

routeUsuario.post("/v1/usuarios/enderecos", verifyJWT, controllerCliente.InserirEndereco);

routeUsuario.put("/v1/usuarios/enderecos/:id_endereco", verifyJWT, controllerCliente.EditarEndereco);

routeUsuario.delete("/v1/usuarios/enderecos/:id_endereco", verifyJWT, controllerCliente.ExcluirEndereco);

routeUsuario.put("/v1/usuarios/enderecos/padrao/:id_endereco", verifyJWT, controllerCliente.EnderecoPadrao);

//FIM DOS ENDEREÇOS
//INICIO DOS USUÁRIOS

routeUsuario.post("/v1/clientes/login",validate.Login, controllerCliente.Login);

routeUsuario.post("/v1/clientes/registro", validate.Inserir, controllerCliente.InserirCliente);

routeUsuario.get("/v1/clientes/:id_cliente", verifyJWT, controllerCliente.ListarID);

routeUsuario.put("/v1/clientes/", [verifyJWT], controllerCliente.Editar);

routeUsuario.put("/v1/clientes/assas/:id_cliente", controllerCliente.EditarClienteAssas);

routeUsuario.post("/v1/clientes/assas/cartao", verifyJWT, controllerCliente.InserirCartao);

routeUsuario.get("/v1/clientes/assas/cartao", verifyJWT, controllerCliente.ListarCartoes);

export default routeUsuario;