import {db, executeQuery} from '../config/database.js';
import bcrypt from 'bcryptjs';

async function InserirProfissional(DadosProfissional,callback){
    let ssql = "INSERT INTO profissionais(nome, celular, servico, email, senha, regiao_servico, data_cadastro, ativo,foto) VALUES (?,?,?,?,?,?,current_timestamp(),'A',?)";

    const criptSenha = await bcrypt.hash(DadosProfissional.senha,10);
    db.query(ssql,[DadosProfissional.nome,
            DadosProfissional.celular,
            DadosProfissional.servico,
            DadosProfissional.email,
            criptSenha,
            DadosProfissional.regiao_servico,
            DadosProfissional.foto
        ],function(err,result){
        callback(err,result);
    });
};

function LoginProfissional(email,callback){
    let ssql = "SELECT * FROM profissionais WHERE email = ?";

    db.query(ssql,[email],function(err,result){
        callback(err,result);
    });
};

function ListarProfissionais(id_servico,id_profissional,profissional,regiao,pagina,callback){

    let filtro = [];
    let ssql = "SELECT P.*, coalesce(P.avaliacao, 0) as avaliacao, coalesce(P.qtd_avaliacao, 0) as qtd_avaliacao, S.servico FROM profissionais P INNER JOIN servicos S ON P.id_servico = S.id_servico WHERE P.ibge = ? AND P.ativo = 'A'";

    filtro.push(regiao);

    if(id_servico > 0){
        ssql += " AND P.id_servico = ? ";
        filtro.push(id_servico);
    } 

    if(id_profissional > 0){
        ssql += " AND P.id_profissional = ? ";
        filtro.push(id_profissional);
    } 

    if(profissional?.length > 0){
        ssql += " AND P.nome LIKE ? ";
        filtro.push('%'+profissional+'%');
    }

    ssql += " ORDER BY P.avaliacao,P.qtd_avaliacao ASC";

    if(pagina){
        ssql += " LIMIT ?,? ";
        filtro.push((pagina-1)*10);
        filtro.push(10);
    }

    db.query(ssql,filtro,function(err,result){
        callback(err,result);
    });
};

function EditarProfissional(id_profissional,DadosProfissional,callback){

    let ssql = "UPDATE profissionais SET nome=?,celular=?,servico=?,email=?,regiao_servico=?,ativo=?,foto=? WHERE id_profissional = ?";

    db.query(ssql,[DadosProfissional.nome,
        DadosProfissional.celular,
        DadosProfissional.servico,
        DadosProfissional.email,
        DadosProfissional.regiao_servico,DadosProfissional.ativo,DadosProfissional.foto,id_profissional],function(err,result){
        callback(err,result);
    });
};

async function AtualizarSenha(id_profissional,senha,callback){
    let ssql = "UPDATE profissionais SET senha=? WHERE id_profissional = ?";
    const criptSenha = await bcrypt.hash(senha,10);
    db.query(ssql,[criptSenha, id_profissional],function(err,result){
        callback(err,result);
    });
}

function InserirVitrine(DadosVitrine,callback){
    let ssql = "INSERT INTO vitrine(id_profissional, url_foto, legenda) VALUES (?,?,?)";

    db.query(ssql,[DadosVitrine.id_profissional,DadosVitrine.foto,DadosVitrine.legenda],function(err,result){
        callback(err,result);
    });
};

function ListarVitrine(id_profissional,callback){
    let ssql = "SELECT * FROM vitrine WHERE id_profissional = ?";

    ssql += " ORDER BY id_vitrine DESC"

    db.query(ssql,[id_profissional],function(err,result){
        callback(err,result);
    });
};

function ListarServicos(servico,callback){
    let filtro = [];
    let ssql = "SELECT * FROM servicos WHERE 1";

    if(servico > 0){
        ssql += " AND id_servico = ? ";
        filtro.push(servico);
    }
    ssql += " ORDER BY servico ASC"

    db.query(ssql,filtro,function(err,result){
        callback(err,result);
    });
}

export default {InserirProfissional,LoginProfissional,ListarProfissionais,EditarProfissional,AtualizarSenha,InserirVitrine,ListarVitrine,ListarServicos};