import {db, executeQuery} from '../config/database.js';

function InserirUnidade(DadosUnidade,callback){
    let ssql = "INSERT INTO unidades(unidade, sigla) VALUES (?,?)";

    db.query(ssql,[DadosUnidade.unidade,DadosUnidade.sigla],function(err,result){
        callback(err,result);
    });
};

function ListarUnidade(unidade,callback){

    let filtro = [];
    let ssql = "SELECT * FROM unidades WHERE 1 ";

    if(unidade?.length > 0){
        
        ssql += "AND unidade LIKE ? ";
        filtro.push('%'+unidade+'%');
    }

    ssql += " ORDER BY unidade ASC"

    db.query(ssql,[filtro],function(err,result){
        callback(err,result);
    });
};

function AtualizarUnidade(DadosUnidade,id_unidade,callback){
    let ssql = "UPDATE unidades SET unidade=?,sigla=? WHERE id_unidade = ?";

    db.query(ssql,[DadosUnidade.unidade,DadosUnidade.sigla,id_unidade],function(err,result){
        callback(err,result);
    });
};

function InserirProduto(DadosProduto,callback){

    // let ssql = "INSERT INTO produtos(id_empresa, id_departamento, id_unidade, descricao, produto, foto, valor_venda, valor_custo, estoque, estoque_min, estoque_max, validade, id_marca, id_fornecedor, codigo_barra, variacoes) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    // db.query(ssql,[DadosProduto.id_empresa,DadosProduto.id_departamento,DadosProduto.id_unidade,DadosProduto.descricao,DadosProduto.produto,DadosProduto.foto,DadosProduto.venda,DadosProduto.custo,DadosProduto.estoque,DadosProduto.min,DadosProduto.max,DadosProduto.validade,DadosProduto.marca,DadosProduto.fornecedor,DadosProduto.codbarra, JSON.stringify(DadosProduto.variacao)],function(err,result){
    //     callback(err,result);
    // });

    db.getConnection(function(err,conn){
        conn.beginTransaction(async function(err){
            try {
                
           
                let ssql = "INSERT INTO produtos(id_empresa, id_departamento, id_unidade, descricao, produto, foto, valor_venda, valor_custo, valor_promocao, estoque, estoque_min, estoque_max, validade, id_marca, id_fornecedor, codigo_barra) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                //PRODUTO
                let produto = await executeQuery(conn,ssql,[DadosProduto.id_empresa,DadosProduto.id_departamento,DadosProduto.id_unidade,DadosProduto.descricao,DadosProduto.produto,DadosProduto.foto,DadosProduto.venda,DadosProduto.custo,DadosProduto.promocao,DadosProduto.estoque,DadosProduto.min,DadosProduto.max,DadosProduto.validade,DadosProduto.marca,DadosProduto.fornecedor,DadosProduto.codbarra])
                
                let id_produto = produto.insertId;

                //VARIAÇÕES DO PRODUTO
                for (let i = 0; i < DadosProduto.variacao.length; i++) {

                    let item = DadosProduto.variacao[i];


                    ssql = "INSERT INTO variacoes(id_produto, tipo_variacao, descricao, preco) VALUES (?,?,?,?)";

                    let ret = await executeQuery(conn,ssql,[id_produto,item['tipo_variacao'],item['descricao'],item['preco']]);
                    
                }
                
                conn.commit();

                callback(undefined,produto);
                
            } catch (error) {
              conn.rollback();
              callback(error,{})  
            }

        conn.release();

        });
        
    })

    // db.getConnection(function(err,conn){
    //         conn.beginTransaction(async function(err){
    //             let ssql = "INSERT INTO produtos(id_empresa, id_departamento, id_unidade, descricao, produto, foto, valor_venda, valor_custo, estoque, estoque_min, estoque_max, validade, id_marca, id_fornecedor, codigo_barra) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    
    //             conn.query(ssql,[DadosProduto.id_empresa,DadosProduto.id_departamento,DadosProduto.id_unidade,DadosProduto.descricao,DadosProduto.produto,DadosProduto.foto,DadosProduto.venda,DadosProduto.custo,DadosProduto.estoque,DadosProduto.min,DadosProduto.max,DadosProduto.validade,DadosProduto.marca,DadosProduto.fornecedor,DadosProduto.codbarra], function(err,result){
    //                     if(err){
    //                         conn.rollback();
    //                         callback(err,result);
    //                     }else{
    //                         const id_produto = result.insertId;
    
    //                         ssql = "INSERT INTO variacoes(id_produto, variacoes) VALUES (?,?)";
    
    //                         conn.query(ssql,[id_produto,JSON.stringify(DadosProduto.variacao)],function(err,result){
    //                             if(err){
    //                                 conn.rollback();
    //                             }else{
    //                                 conn.commit();
                                    
    //                             }
    //                             conn.release();
    //                             callback(err,{id_produto});
    //                         });
    //                     }
    //             })
    
    //         });
    //     })
};


function ListarProduto(produto,id_empresa,id_fornecedor,id_departamento,cidade,id_produto,pagina,callback){

    let filtro = [];
    let ssql = "SELECT P.*, coalesce(P.valor_promocao, 0.00) as valor_promocao, D.departamento, E.fantasia, U.unidade,U.sigla, M.marca, F.fantasia FROM produtos P INNER JOIN departamentos D ON P.id_departamento = D.id_departamento INNER JOIN empresas E ON P.id_empresa = E.id_empresa INNER JOIN unidades U ON P.id_unidade = U.id_unidade INNER JOIN marcas M ON P.id_marca = M.id_marca INNER JOIN fornecedores F ON P.id_fornecedor = F.id_fornecedor WHERE E.ibge = ? ";

    filtro.push(cidade);
    
    if(id_produto > 0){
        ssql += " AND P.id_produto = ?"
        filtro.push(id_produto);
    }

    if(id_empresa > 0){
        ssql += " AND P.id_empresa = ?"
        filtro.push(id_empresa);
     }
    
    if(produto?.length > 0){
        ssql += " AND P.produto LIKE ? ";
        filtro.push('%'+produto+'%');
    }

    if(id_departamento > 0){
        ssql += " AND P.id_departamento = ? ";
        filtro.push(id_departamento);
    }

    if(id_fornecedor > 0){
        ssql += " AND P.id_fornecedor = ? ";
        filtro.push(id_fornecedor);
    }

    ssql += " ORDER BY P.produto ASC";

    if(pagina){
        ssql += " LIMIT ?,? ";
        filtro.push((pagina-1)*10);
        filtro.push(10);
    }

    db.query(ssql,filtro,function(err,result){
        callback(err,result);
    });
};

function AtualizarProduto(DadosProduto,id_produto,callback){
    let ssql = "UPDATE produtos SET descricao=?,produto=?,foto=?,valor_venda=?,valor_custo=?,valor_promocao=?,estoque_min=?,estoque_max=?,validade=? WHERE id_produto = ?";

    db.query(ssql,[DadosProduto.descricao,DadosProduto.produto,DadosProduto.foto,DadosProduto.venda,DadosProduto.custo,DadosProduto.promocao,DadosProduto.min,DadosProduto.max,DadosProduto.validade,id_produto],function(err,result){
        callback(err,result);
    });
};

function ListarVariacoes(id_produto,callback){

    let ssql = "SELECT V.*, T.* FROM variacoes V INNER JOIN tipo_variacao T ON V.tipo_variacao = T.id_tipo_variacao WHERE id_produto = ?";

    db.query(ssql,[id_produto],function(err,result){
        callback(err,result);
    });
};

function InserirTipoVariacao(DadosVariacao,callback){
    let ssql = "INSERT INTO tipo_variacao(tipo_variacao) VALUES (?)";

    db.query(ssql,[DadosVariacao.tipo_variacao],function(err,result){
        callback(err,result);
    });
};

function ListarTipoVariacoes(callback){

    let ssql = "SELECT * FROM tipo_variacao";

    db.query(ssql,[],function(err,result){
        callback(err,result);
    });
};

function ListarmaisVendidos(id_empresa,inicio,fim,callback){
    let ssql = "SELECT P.id_produto, P.produto, P.valor_venda, P.foto, SUM(IP.qtd) AS vendidos, SUM(IP.qtd * IP.valor_unitario) AS receita FROM produtos P JOIN pedido_itens IP ON P.id_produto = IP.id_produto JOIN pedidos PD ON PD.id_pedido = IP.id_pedido WHERE P.id_empresa = ? AND PD.data_pedido BETWEEN ? AND ? GROUP BY P.id_produto ORDER BY vendidos DESC LIMIT 5;"

    db.query(ssql,[id_empresa,inicio,fim],function(err,result){
        callback(err,result);
    });
}

export default {InserirUnidade,ListarUnidade,AtualizarUnidade,InserirProduto,ListarProduto,AtualizarProduto,ListarVariacoes,InserirTipoVariacao,ListarTipoVariacoes,ListarmaisVendidos};