import {db, executeQuery} from '../config/database.js';

function Inserir(id_usuario,jsonPed,callback){
    db.getConnection(function(err,conn){
        conn.beginTransaction(async function(err){
            try {
                
           
                let ssql = "INSERT INTO pedidos(id_cliente, id_empresa, id_endereco, taxa_entrega, valor_desconto, valor_total, data_pedido,forma_pagamento,parcelas,status,assas,token_cartao) VALUES (?,?,?,?,?,?,CURRENT_TIMESTAMP(),?,?,?,?,?)";

                //PEDIDO
                let pedido = await executeQuery(conn,ssql,[id_usuario,jsonPed.id_empresa,jsonPed.endereco,jsonPed.entrega,jsonPed.desconto,jsonPed.total,jsonPed.forma,jsonPed.parcela,'A',jsonPed.assas,jsonPed.token])
                
                let id_pedido = pedido.insertId;

                //ITENS DO PEDIDO
                for (let i = 0; i < jsonPed.itens.length; i++) {
                    let item = jsonPed.itens[i];

                    ssql = "INSERT INTO pedido_itens(id_pedido, id_produto, qtd, valor_unitario, valor_total) VALUES (?,?,?,?,?)";

                    let ret = await executeQuery(conn,ssql,[id_pedido,item.id_produto,item.qtd,item.vl_unit,item.vl_total]);

                    let id_pedido_item = ret.insertId;


                    // Detalhes...
                    for (let x = 0; x < item.variacao.length; x++) {
                        let variacao = item.variacao[x];

                        ssql =  "insert into pedido_item_variacao(id_pedido_item, nome, id_item, vl_item) ";
                        ssql += "values (?, ?, ?, ?)";

                        await executeQuery(conn, ssql, [id_pedido_item, variacao.nome, variacao.id_item, 
                            variacao.vl_item]);
                    }
                    
                }
                
                conn.commit();

                callback(undefined,pedido);
                
            } catch (error) {
              conn.rollback();
              callback(error,{})  
            }

        conn.release();

        });
        
    })
};

function Listar(id_usuario,callback){
    let ssql = "SELECT P.*, E.fantasia, E.logo, count(*) as qtd_item, coalesce(E.avaliacao, 0) as avaliacao FROM pedidos P INNER JOIN empresas E ON P.id_empresa = E.id_empresa LEFT JOIN pedido_itens I ON I.id_pedido = P.id_pedido WHERE P.id_cliente = ? GROUP BY P.id_pedido ORDER BY P.id_pedido DESC";

    db.query(ssql,[id_usuario],function(err,result){
        callback(err,result);
    });
};

function ListarEmpresa(id_empresa,id_pedido,callback){
    
    let filtro = [];
    let ssql = "SELECT P.*, C.razao_social as nome, E.*, COUNT(*) as qtd_pedido FROM pedidos P INNER JOIN clientes C ON P.id_cliente = C.id_cliente INNER JOIN enderecos E ON P.id_endereco = E.id_endereco LEFT JOIN pedido_itens I ON I.id_pedido = P.id_pedido WHERE P.id_empresa = ? ";
    filtro.push(id_empresa);

    if(id_pedido){
        ssql += " AND P.id_pedido = ?";
        filtro.push(id_pedido);
    }

    ssql += " GROUP BY P.id_pedido";

    db.query(ssql,filtro,function(err,result){
        callback(err,result);
    });
};

function ListarItens(id_pedido,pagina,callback){
    let filtro = [];
    let ssql = "SELECT I.*, P.produto FROM pedido_itens I INNER JOIN produtos P ON I.id_produto = P.id_produto WHERE I.id_pedido = ?";
    filtro.push(id_pedido);
    
    if(pagina){
        ssql += " LIMIT ?,? ";
        filtro.push((pagina-1)*10);
        filtro.push(10);
    }

    db.query(ssql,filtro,function(err,result){
        callback(err,result);
    });
};

function AtualizarStatus(status,id_pedido,callback){
    let ssql = "UPDATE pedidos SET status=? WHERE id_pedido = ?";

    db.query(ssql,[
        status,id_pedido],function(err,result){
            callback(err,result);
    });
};

function AtualizarStatusCancelamento(motivo,id_pedido,callback){
    let ssql = "UPDATE pedidos SET status='C', motivo_cancelado = ?, data_cancelamento = current_timestamp() WHERE id_pedido = ?";

    db.query(ssql,[
        motivo,id_pedido],function(err,result){
            callback(err,result);
    });
};

function AvaliarPedido(avaliacao,id_pedido,callback){
    let ssql = "UPDATE pedidos SET avaliacao=? WHERE id_pedido = ?";

    db.query(ssql,[
        avaliacao,id_pedido],function(err,result){
            callback(err,result);
    });
};

function AvaliarItens(avaliacao,id_item,callback){
    let ssql = "UPDATE pedido_itens SET avaliacao=? WHERE id_pedido_itens = ?";

    db.query(ssql,[
        avaliacao,id_item],function(err,result){
            callback(err,result);
    });
};

function ListarPedidoCliente(id_cliente,id_pedido,id_empresa, callback){
    let ssql = "SELECT P.*, C.*, E.* FROM pedidos P INNER JOIN clientes C ON P.id_cliente = C.id_cliente INNER JOIN enderecos E ON P.id_endereco = E.id_endereco WHERE C.id_cliente = ? AND P.id_pedido = ? AND P.id_empresa = ?";

    db.query(ssql,[id_cliente,id_pedido,id_empresa],function(err,result){
            callback(err,result);
    });
}

function gerarSenhaAleatoria() {
    return Math.floor(1000 + Math.random() * 9000); // Gera um número aleatório de 4 dígitos
}

function AbrituirEntregador(id_pedido,jsonPed, callback){

    let ssql = "INSERT INTO pedidos_entregador(id_pedido, id_entregador, latitude_atual, longitude_atual, data_atribuicao,senha) VALUES (?,?,?,?,CURRENT_TIMESTAMP(),?)";

    db.query(ssql,[id_pedido,jsonPed.id_entregador,jsonPed.latitude_atual,jsonPed.longitude_atual,gerarSenhaAleatoria()],function(err,result){
            callback(err,result);
    });
}

function ListarEntregador(id_pedido,callback){
    let ssql = "SELECT P.*, E.fantasia, E.logo, E.endereco AS endereco_loja, E.numero AS nro_loja, ENDE.endereco AS endereco_entrega, ENDE.numero AS nro_entrega, COUNT(I.id_pedido) AS qtd_item, PE.senha FROM pedidos P INNER JOIN empresas E ON P.id_empresa = E.id_empresa LEFT JOIN pedido_itens I ON I.id_pedido = P.id_pedido INNER JOIN enderecos ENDE ON P.id_endereco = ENDE.id_endereco left JOIN pedidos_entregador PE ON P.id_pedido = PE.id_pedido WHERE P.id_pedido = ? GROUP BY P.id_pedido, E.fantasia, E.logo, E.endereco, E.numero, ENDE.endereco, ENDE.numero, PE.senha;";

    db.query(ssql,[id_pedido],function(err,result){
        callback(err,result);
    });
};

function ListarPedidosRecentes(id_empresa, dataInicio, dataFim, callback) {
const filtro = [id_empresa, dataInicio, dataFim];

let ssql = `
  SELECT 
    P.*, 
    C.razao_social AS nome, 
    E.*, 
    COUNT(*) AS qtd_pedido
  FROM pedidos P
  INNER JOIN clientes C ON P.id_cliente = C.id_cliente
  INNER JOIN enderecos E ON P.id_endereco = E.id_endereco
  LEFT JOIN pedido_itens I ON I.id_pedido = P.id_pedido
  WHERE P.id_empresa = ?
    AND DATE(P.data_pedido) BETWEEN ? AND ?
  GROUP BY P.id_pedido
  ORDER BY P.id_pedido DESC
  LIMIT 10
`;

db.query(ssql, filtro, function (err, result) {
  callback(err, result);
});
}

function ListarVendas(id_empresa, dataInicio, dataFim, callback) {
  const ssql = `
    SELECT COUNT(*) AS total_vendas
    FROM pedidos
    WHERE id_empresa = ?
      AND DATE(data_pedido) BETWEEN ? AND ?
  `;
  
  const filtro = [id_empresa, dataInicio, dataFim];

  db.query(ssql, filtro, function (err, result) {
    callback(err, result);
  });
}

function ListarClientes(id_empresa, dataInicio, dataFim, callback){
const ssql = `
  SELECT COUNT(DISTINCT id_cliente) AS total_vendas
FROM pedidos
WHERE id_empresa = ?
  AND DATE(data_pedido) BETWEEN ? AND ?
`;

const filtro = [id_empresa, dataInicio, dataFim];

db.query(ssql, filtro, function (err, result) {
  callback(err, result);
});
};

function NotificacaoEmpresa(jsonPed, callback){

    let ssql = "INSERT INTO notificacoes_empresa(empresa_id, titulo, mensagem, classe_icone, lida, data_criacao) VALUES (?,?,?,?,?,CURRENT_TIMESTAMP)";

    db.query(ssql,[jsonPed.id_empresa,jsonPed.titulo,jsonPed.msg,jsonPed.classe,1],function(err,result){
            callback(err,result);
    });
}

function NotificacaoMostrar(id_empresa, tipo, pagina, total, callback) {
    let filtro = [id_empresa];
    let ssql = "SELECT * FROM notificacoes_empresa WHERE empresa_id = ?";

    ssql += " ORDER BY id_notificacao DESC";

    if (tipo === "notifica") {
        ssql += " LIMIT 0, 4"; // pega os 4 mais recentes
    } else {
        const offset = (pagina - 1) * total;
        ssql += " LIMIT ?, ?";
        filtro.push(offset, total);
    }

    db.query(ssql, filtro, function(err, result) {
        callback(err, result);
    });
}

export default {Inserir,Listar,ListarEmpresa,ListarItens,AtualizarStatus,AtualizarStatusCancelamento,AvaliarPedido,AvaliarItens,ListarPedidoCliente,AbrituirEntregador,ListarEntregador,ListarPedidosRecentes,ListarVendas,ListarClientes,NotificacaoEmpresa,NotificacaoMostrar};