import {db, executeQuery} from '../config/database.js';

function InserirMarca(DadosMarca,callback){
    let ssql = "INSERT INTO marcas(id_empresa,marca, ativo) VALUES (?,?,?)";

    db.query(ssql,[
        DadosMarca.id_empresa,
        DadosMarca.marca,
        DadosMarca.ativo],function(err,result){
        callback(err,result);
    });
};

function ListarMarca(marca,id_empresa,callback){

    let filtro = [];
    let ssql = "SELECT * FROM marcas WHERE id_empresa = ? ";
    filtro.push(id_empresa)

    if(marca?.length > 0){
        ssql += " AND marca LIKE ? ";
        filtro.push('%'+marca+'%');
    }

    ssql += " ORDER BY marca ASC";

    db.query(ssql,filtro,function(err,result){
        callback(err,result);
    });
};

function AtualizarMarca(DadosMarca,id_marca,id_empresa,callback){
    let ssql = "UPDATE marcas SET marca=?,ativo=? WHERE id_marca = ? AND id_empresa = ?";

    db.query(ssql,[
        DadosMarca.marca,
        DadosMarca.ativo,id_marca,id_empresa],function(err,result){
            callback(err,result);
    });
};

function BuscarMarca(id_marca,id_empresa,callback){

    let ssql = "SELECT * FROM marcas WHERE id_empresa = ? AND id_marca = ?";

    db.query(ssql,[id_empresa,id_marca],function(err,result){
        callback(err,result);
    });
};

export default {InserirMarca, ListarMarca,AtualizarMarca,BuscarMarca};