import {db, executeQuery} from '../config/database.js';

function InserirFornecedor(DadosFornecedor,callback){
    let ssql = "INSERT INTO fornecedores(id_empresa,razao_social, fantasia, tipo, cnpj, inscricao_estadual, inscricao_municipal, email, ativo, cep, endereco, numero, bairro, complemento, ibge, cidade, uf) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    db.query(ssql,[
        DadosFornecedor.id_empresa,
        DadosFornecedor.razao_social,
        DadosFornecedor.fantasia,
        DadosFornecedor.tipo,
        DadosFornecedor.cnpj,
        DadosFornecedor.inscricao_estadual,
        DadosFornecedor.inscricao_municipal,
        DadosFornecedor.email,
        DadosFornecedor.ativo,
        DadosFornecedor.cep,
        DadosFornecedor.endereco,
        DadosFornecedor.numero,
        DadosFornecedor.bairro,
        DadosFornecedor.complemento,
        DadosFornecedor.ibge,
        DadosFornecedor.cidade,
        DadosFornecedor.uf],function(err,result){
        callback(err,result);
    });
};

function ListarFornecedor(fornecedor,id_empresa,callback){

    let filtro = [];
    let ssql = "SELECT * FROM fornecedores WHERE id_empresa = ? ";

    filtro.push(id_empresa)
    if(fornecedor?.length > 0){
        ssql += " AND fantasia LIKE ? ";
        filtro.push('%'+fornecedor+'%');
    }

    ssql += " ORDER BY fantasia ASC";

    db.query(ssql,filtro,function(err,result){
        callback(err,result);
    });
};

function AtualizarFornecedor(DadosFornecedor,id_fornecedor,id_empresa,callback){
    let ssql = "UPDATE fornecedores SET razao_social=?,fantasia=?,tipo=?,cnpj=?,inscricao_estadual=?,inscricao_municipal=?,email=?,ativo=?,cep=?,endereco=?,numero=?,bairro=?,complemento=?,ibge=?,cidade=?,uf=? WHERE id_fornecedor = ? AND id_empresa = ?";

    db.query(ssql,[DadosFornecedor.razao_social,
        DadosFornecedor.fantasia,
        DadosFornecedor.tipo,
        DadosFornecedor.cnpj,
        DadosFornecedor.inscricao_estadual,
        DadosFornecedor.inscricao_municipal,
        DadosFornecedor.email,
        DadosFornecedor.ativo,
        DadosFornecedor.cep,
        DadosFornecedor.endereco,
        DadosFornecedor.numero,
        DadosFornecedor.bairro,
        DadosFornecedor.complemento,
        DadosFornecedor.ibge,
        DadosFornecedor.cidade,
        DadosFornecedor.uf, id_fornecedor,id_empresa],function(err,result){
        callback(err,result);
    });
};

function BuscarFornecedor(id_fornecedor,id_empresa,callback){

    let ssql = "SELECT * FROM fornecedores WHERE id_empresa = ? AND id_fornecedor = ?";

    db.query(ssql,[id_empresa,id_fornecedor],function(err,result){
        callback(err,result);
    });
};

export default {InserirFornecedor, ListarFornecedor,AtualizarFornecedor,BuscarFornecedor};