import {db, executeQuery} from '../config/database.js';

async function InserirEntrega(DadosEntrega,callback){
    let ssql = "INSERT INTO entregas(id_entregador, id_pedido, data, status) VALUES (?,?,current_timestamp(),'A')";

    db.query(ssql,[DadosEntrega.entregador,
        DadosEntrega.pedido
        ],function(err,result){
        callback(err,result);
    });
};

function ListarEntregas(id_entregador,callback){
    let ssql = "SELECT D.*, E.*, P.* FROM entregas D INNER JOIN entregadores E ON D.id_entregador = E.id_entregador INNER JOIN pedidos P ON D.id_pedido = P.id_pedido WHERE D.id_entregador = ?";

    db.query(ssql,[id_entregador],function(err,result){
        callback(err,result);
    });
};

function EditarStatus(id_entrega,DadosEntrega,callback){

    let ssql = "UPDATE entregas SET status=? WHERE id_entrega = ?";

    db.query(ssql,[DadosEntrega.status, id_entrega],function(err,result){
        callback(err,result);
    });
};

export default {InserirEntrega,ListarEntregas,EditarStatus};