import {db, executeQuery} from '../config/database.js';
import bcrypt from 'bcryptjs';

async function InserirEntregador(DadosEntregador,callback){
    let ssql = "INSERT INTO entregadores(nome, cpf, modalidade_entrega, foto, foto_documento, celular, regiao_atendimento, cep, endereco, numero, bairro, complemento, ibge, cidade, uf, status, email, senha, data_cadastro,placa,marca,modelo,ano) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'L',?,?,current_timestamp(),?,?,?,?)";

    const criptSenha = await bcrypt.hash(DadosEntregador.senha,10);
    db.query(ssql,[DadosEntregador.nome,
            DadosEntregador.cpf,
            DadosEntregador.modalidade_entrega,
            DadosEntregador.foto,
            DadosEntregador.foto_documento,
            DadosEntregador.celular,
            DadosEntregador.regiao_atendimento,
            DadosEntregador.cep,
            DadosEntregador.endereco,
            DadosEntregador.numero,
            DadosEntregador.bairro,
            DadosEntregador.complemento,
            DadosEntregador.ibge,
            DadosEntregador.cidade,
            DadosEntregador.uf,
            DadosEntregador.email,
            criptSenha,
            DadosEntregador.placa,
            DadosEntregador.marca,
            DadosEntregador.modelo,
            DadosEntregador.ano
        ],function(err,result){
        callback(err,result);
    });
};

function LoginEntregador(email,callback){
    let ssql = "SELECT * FROM entregadores WHERE email = ?";

    db.query(ssql,[email],function(err,result){
        callback(err,result);
    });
};

function ListarID(id_entregador,callback){
    let ssql = "SELECT E.*, M.modalidade ";
    ssql+="FROM entregadores E INNER JOIN modalidade_entrega M ON E.modalidade_entrega = M.id_modalidade ";
    ssql+="WHERE E.id_entregador = ?";

    db.query(ssql,[id_entregador],function(err,result){
        callback(err,result);
    });
};

function EditarEntregador(id_entregador,DadosEntregador,callback){

    let ssql = "UPDATE entregadores SET nome=?,celular=?,cep=?,endereco=?,numero=?,bairro=?,complemento=?,ibge=?,cidade=?,uf=?,status=?,email=? WHERE id_entregador = ?";

    db.query(ssql,[DadosEntregador.nome,
        DadosEntregador.celular,
        DadosEntregador.cep,
        DadosEntregador.endereco,
        DadosEntregador.numero,
        DadosEntregador.bairro,
        DadosEntregador.complemento,
        DadosEntregador.ibge,
        DadosEntregador.cidade,
        DadosEntregador.uf,
        DadosEntregador.status,
        DadosEntregador.email,
        id_entregador],function(err,result){
        callback(err,result);
    });
};

function EditarFoto(id_entregador,DadosEntregador,callback){

    let ssql = "UPDATE entregadores SET foto=? WHERE id_entregador = ?";

    db.query(ssql,[DadosEntregador.foto,
         id_entregador],function(err,result){
        callback(err,result);
    });
};

function EditarVeiculo(id_entregador,DadosEntregador,callback){

    let ssql = "UPDATE entregadores SET modalidade_entrega=?,foto_documento=?,placa=?,marca=?,modelo=?,ano=? WHERE id_entregador = ?";

    db.query(ssql,[DadosEntregador.modalidade_entrega,
        DadosEntregador.foto_documento,
        DadosEntregador.placa,
        DadosEntregador.marca,
        DadosEntregador.modelo,
        DadosEntregador.ano, id_entregador],function(err,result){
        callback(err,result);
    });
};

async function AtualizarSenha(id_entregador,senha,callback){
    let ssql = "UPDATE entregadores SET senha=? WHERE id_entregador = ?";
    const criptSenha = await bcrypt.hash(senha,10);
    db.query(ssql,[criptSenha, id_entregador],function(err,result){
        callback(err,result);
    });
}

function ListarPedidoEntrega(id_pedido,callback){
    let ssql = "SELECT EN.nome, EN.placa, EN.marca, EN.modelo, EN.ano, EN.foto, P.*, EM.fantasia, PEN.*, ED.* ";
    ssql += "FROM pedidos P ";
    ssql += "INNER JOIN empresas EM ON P.id_empresa = EM.id_empresa ";
    ssql += "INNER JOIN enderecos ED ON P.id_endereco = ED.id_endereco ";
    ssql += "LEFT JOIN pedidos_entregador PEN ON PEN.id_pedido = P.id_pedido ";
    ssql += "LEFT JOIN entregadores EN ON PEN.id_entregador = EN.id_entregador ";
    ssql += "WHERE P.id_pedido = ?";

    db.query(ssql,[id_pedido],function(err,result){
        callback(err,result);
    });
};

function ListarModalidade(callback){
    let ssql = "SELECT * FROM modalidade_entrega ORDER BY modalidade ASC";

    db.query(ssql,[],function(err,result){
        callback(err,result);
    });
}

function InserirPedidoEntrega(id_pedido,callback){
    const senha = Math.floor(1000 + Math.random() * 9000); // número entre 1000 e 9999

    let ssql = "INSERT INTO pedidos_entregador(id_pedido, data_atribuicao, senha) VALUES (?,CURRENT_TIMESTAMP(),?)";

    db.query(ssql,[id_pedido,senha],function(err,result){
        callback(err,result);
    });
};

function AtualizarPedidoEntregaEntregador(id_pedido,dados_entregador,callback){
    let ssql = "UPDATE pedidos_entregador SET id_entregador=?,latitude_atual=?,longitude_atual=?,data_atribuicao=CURRENT_TIMESTAMP() WHERE id_pedido = ?";

    db.query(ssql,[dados_entregador.id_entregador,
        dados_entregador.latitude,
        dados_entregador.longitude,
        id_pedido],function(err,result){
        callback(err,result);
    });
};

function AtualizarCoordenadas(id_pedido,dados_entregador,callback){
    let ssql = "UPDATE pedidos_entregador SET latitude_atual=?,longitude_atual=? WHERE id_pedido = ?";

    db.query(ssql,[dados_entregador.latitude,
        dados_entregador.longitude,
        id_pedido],function(err,result){
        callback(err,result);
    });
};

export default {InserirEntregador,LoginEntregador,ListarID,EditarEntregador,EditarFoto,EditarVeiculo,AtualizarSenha,ListarPedidoEntrega,ListarModalidade,InserirPedidoEntrega,AtualizarPedidoEntregaEntregador,AtualizarCoordenadas};