import {db, executeQuery} from '../config/database.js';
import bcrypt from 'bcryptjs';

async function Inserir(dadosEmpresa,callback){
    // let ssql = "INSERT INTO empresas(razao_social, fantasia, cnpj, inscricao_estadual, inscricao_municipal, cep, endereco, numero, bairro, complemento, ibge, cidade, uf, telefone, site, email, senha, data_cadastro, matriz_filial, logo, ativo, cnae) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,current_timestamp(),?,?,?,?)";

    // const criptSenha = await bcrypt.hash(dadosEmpresa.senha,10);
    // db.query(ssql,[dadosEmpresa.razao_social,dadosEmpresa.fantasia,dadosEmpresa.cnpj,dadosEmpresa.inscricao_estadual,dadosEmpresa.inscricao_municipal,dadosEmpresa.cep,dadosEmpresa.endereco,dadosEmpresa.numero,dadosEmpresa.bairro,dadosEmpresa.complemento,dadosEmpresa.ibge,dadosEmpresa.cidade,dadosEmpresa.uf,dadosEmpresa.telefone,dadosEmpresa.site,dadosEmpresa.email,criptSenha,dadosEmpresa.matriz_filial,dadosEmpresa.logo,1,dadosEmpresa.cnae],function(err,result){
    //     callback(err,result);
    // });

    db.getConnection(function(err,conn){
        conn.beginTransaction(async function(err){
            try {
                
           
                let ssql = "INSERT INTO empresas(razao_social, fantasia, cnpj, inscricao_estadual, inscricao_municipal, cep, endereco, numero, bairro, complemento, ibge, cidade, uf, telefone, site, email, senha, data_cadastro, matriz_filial, logo, ativo, cnae) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,current_timestamp(),?,?,?,?)";
                const criptSenha = await bcrypt.hash(dadosEmpresa.senha,10);
                //EMPRESA
                let empresa = await executeQuery(conn,ssql,[dadosEmpresa.razao_social,dadosEmpresa.fantasia,dadosEmpresa.cnpj,dadosEmpresa.inscricao_estadual,dadosEmpresa.inscricao_municipal,dadosEmpresa.cep,dadosEmpresa.endereco,dadosEmpresa.numero,dadosEmpresa.bairro,dadosEmpresa.complemento,dadosEmpresa.ibge,dadosEmpresa.cidade,dadosEmpresa.uf,dadosEmpresa.telefone,dadosEmpresa.site,dadosEmpresa.email,criptSenha,dadosEmpresa.matriz_filial,dadosEmpresa.logo,1,dadosEmpresa.cnae])
                
                let id_empresa = empresa.insertId;

                //ITENS DO DEPARTAMENTO
                for (let i = 0; i < dadosEmpresa.departamentos.length; i++) {
                    let item = dadosEmpresa.departamentos[i];

                    ssql = "INSERT INTO departamento_empresas(id_empresa, id_departamento) VALUES (?,?)";

                    let ret = await executeQuery(conn,ssql,[id_empresa,item.departamento]);
                    
                }
                
                conn.commit();

                callback(undefined,empresa);
                
            } catch (error) {
              conn.rollback();
              callback(error,{})  
            }

        conn.release();

        });
        
    })
}

function LoginEmpresa(email,callback){
    let ssql = "SELECT * FROM empresas WHERE email = ?";

    db.query(ssql,[email],function(err,result){
        callback(err,result);
    });
};

async function AtualizaEmpresa(dadosEmpresa,id_empresa,callback){
    let ssql = "UPDATE empresas SET razao_social=?,fantasia=?,cep=?,endereco=?,numero=?,bairro=?,complemento=?,ibge=?,cidade=?,uf=?,telefone=?,site=?,email=?,logo=?,ativo=?,cnae=? WHERE id_empresa=?";
    db.query(ssql,[dadosEmpresa.razao_social,dadosEmpresa.fantasia,dadosEmpresa.cep,dadosEmpresa.endereco,dadosEmpresa.numero,dadosEmpresa.bairro,dadosEmpresa.complemento,dadosEmpresa.ibge,dadosEmpresa.cidade,dadosEmpresa.uf,dadosEmpresa.telefone,dadosEmpresa.site,dadosEmpresa.email,dadosEmpresa.logo,dadosEmpresa.ativo,dadosEmpresa.cnae,id_empresa],function(err,result){
        callback(err,{id_empresa});
    });
}

function ListarEmpresa(ibge,empresa,id_empresa,departamento,pagina,callback){
    let filtro = [];
    let ssql = "SELECT *, coalesce(avaliacao, 0) as avaliacao, coalesce(qtd_avaliacao, 0) as qtd_avaliacao FROM empresas E INNER JOIN departamento_empresas DE ON E.id_empresa = DE.id_empresa INNER JOIN departamentos D ON DE.id_departamento = D.id_departamento WHERE 1 ";
    
    if(ibge?.length > 0){
        ssql += "AND  E.ibge = ?";
        filtro.push(ibge);
    }

    
    if(empresa?.length > 0){

        ssql += "AND E.fantasia LIKE ? ";
        filtro.push('%'+empresa+'%');
    }

    if(id_empresa > 0){

        ssql += "AND E.id_empresa = ? ";
        filtro.push(id_empresa);
    }

    if(departamento > 0){

        ssql += "AND DE.id_departamento = ? ";
        filtro.push(departamento);
    }
    
    ssql += " ORDER BY E.fantasia DESC ";

    if(pagina){
        ssql += "LIMIT ?,? ";
        filtro.push((pagina-1)*10);
        filtro.push(10);
    }

    db.query(ssql, filtro,function(err,result){
        callback(err,result);
    });
};

function ListarEmpresaFavoritas(ibge,empresa,id_empresa,departamento,pagina,id_cliente,callback){
    let filtro = [];
    let ssql = "SELECT E.id_empresa AS codigo, E.fantasia, E.logo, E.endereco,E.numero,E.bairro,E.cidade,E.uf, E.site,E.telefone, coalesce(E.avaliacao, 0) as avaliacao, coalesce(E.qtd_avaliacao, 0) as qtd_avaliacao, FC.*, coalesce(FC.id_favorito_cliente, 0) as id_favorito_cliente FROM empresas E LEFT JOIN favoritos_cliente FC on (FC.id_empresa = E.id_empresa and FC.id_cliente = ?) WHERE E.ibge = ? ";

    filtro.push(id_cliente)
    filtro.push(ibge);
    
    if(empresa?.length > 0){

        ssql += "AND E.fantasia LIKE ? ";
        filtro.push('%'+empresa+'%');
    }

    if(id_empresa > 0){

        ssql += "AND E.id_empresa = ? ";
        filtro.push(id_empresa);
    }

    if(departamento > 0){

        ssql += "AND DE.id_departamento = ? ";
        filtro.push(departamento);
    }

    ssql += " ORDER BY E.fantasia DESC ";

    if(pagina){
        ssql += "LIMIT ?,? ";
        filtro.push((pagina-1)*10);
        filtro.push(10);
    }

    db.query(ssql, filtro,function(err,result){
        callback(err,result);
    });
};


function ListarFavoritos(id_cliente,callback){
    let ssql = "SELECT FC.*, E.id_empresa,E.fantasia, E.logo, coalesce(E.avaliacao, 0) as avaliacao, E.endereco,E.numero,E.cidade,E.uf,E.cep,E.bairro,E.ibge,E.complemento FROM favoritos_cliente FC JOIN empresas E ON FC.id_empresa = E.id_empresa WHERE FC.id_cliente = ? ORDER BY E.fantasia";

    db.query(ssql,[id_cliente],function(err,result){
        callback(err,result);
    });
};

function InserirFavorito(id_cliente,id_empresa,callback){
    let ssql = "INSERT INTO favoritos_cliente(id_cliente, id_empresa) VALUES (?,?)";

    db.query(ssql,[id_cliente,id_empresa],function(err,result){
        callback(err,result);
    });
};

function ExcluirFavorito(id_favorito,id_cliente, callback){
    let ssql = "DELETE FROM favoritos_cliente WHERE id_favorito_cliente = ? AND id_cliente = ?";

    db.query(ssql,[id_favorito,id_cliente],function(err,result){
        callback(err,result);
    });
};

function InserirInteresse(dados, callback) {
  const {
    tipo,
    nome_responsavel,
    nome_loja_profissional,
    whatsapp,
    email,
    segmento,
    cidade,
    uf,
    mensagem,
    origem = 'site' // valor padrão caso não venha definido
  } = dados;

  const ssql = `
    INSERT INTO interesses 
    (tipo, nome_responsavel, nome_loja_profissional, whatsapp, email, segmento, cidade, uf, mensagem, origem) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
  `;

  db.query(
    ssql,
    [
      tipo,
      nome_responsavel,
      nome_loja_profissional,
      whatsapp,
      email,
      segmento,
      cidade,
      uf,
      mensagem,
      origem
    ],
    function (err, result) {
      callback(err, result);
    }
  );
}

function BuscarCNAE(descricao, pagina = 1, callback) {
  let filtro = [];
  const limite = 10;
  let ssql = `
    SELECT subclasse AS codigo, subclasse_descricao AS descricao
    FROM cnae
    WHERE 1 = 1
  `;

  if (descricao?.length > 0) {
    ssql += ` AND (subclasse LIKE ? OR subclasse_descricao LIKE ?) `;
    const termo = `%${descricao}%`;
    filtro.push(termo, termo);
  }

  // Calcular OFFSET
  const offset = (pagina - 1) * limite;

  ssql += ` ORDER BY subclasse ASC LIMIT ?, ? `;
  filtro.push(offset, parseInt(limite));

  db.query(ssql, filtro, function (err, result) {
    callback(err, result);
  });
}

export default {Inserir, LoginEmpresa,AtualizaEmpresa, ListarFavoritos,InserirFavorito,ExcluirFavorito,ListarEmpresa,ListarEmpresaFavoritas,InserirInteresse,BuscarCNAE};