import {db, executeQuery} from '../config/database.js';

function InserirEmpresaDestaque(id_destaque,id_empresa,callback){
    let ssql = "INSERT INTO destaques_empresa(id_destaque, id_empresa) VALUES (?,?)";

    db.query(ssql,[id_destaque,id_empresa],function(err,result){
        callback(err,result);
    });
};

function InserirDestaque(descricao,ativo,callback){
    let ssql = "INSERT INTO destaques(descricao, ativo) VALUES (?,?)";

    db.query(ssql,[descricao,ativo],function(err,result){
        callback(err,result);
    });
};

function ListarDestaquesEmpresa(ibge,callback){
    let ssql = "SELECT D.*, DE.*, E.* FROM destaques D JOIN destaques_empresa DE ON D.id_destaque = DE.id_destaque JOIN empresas E ON DE.id_empresa = E.id_empresa WHERE D.ativo = 'S' AND E.ibge = ?";

    db.query(ssql,[ibge],function(err,result){
        callback(err,result);
    });
};

function ListarDestaques(callback){
    let ssql = "SELECT * FROM destaques ORDER BY descricao ASC";

    db.query(ssql,[],function(err,result){
        callback(err,result);
    });
};

function AtualizarDestaque(descricao,ativo,id_destaque,callback){
    let ssql = "UPDATE destaques SET descricao=?,ativo=? WHERE id_destaque = ?";

    db.query(ssql,[descricao,ativo,id_destaque],function(err,result){
        callback(err,result);
    });
};

function AtualizarEmpresaDestaque(id_destaque,id_empresa,id_empresadestaque,callback){
    let ssql = "UPDATE destaques_empresa SET id_destaque=? WHERE id_empresa = ? AND id_destaque_empresa = ?";

    db.query(ssql,[id_destaque,id_empresa,id_empresadestaque],function(err,result){
        callback(err,result);
    });
};


export default {InserirEmpresaDestaque,InserirDestaque,ListarDestaquesEmpresa,ListarDestaques,AtualizarDestaque,AtualizarEmpresaDestaque};