import {db} from '../config/database.js';

function InserirDepartamento(dadosDepartamento,callback){
    let ssql = "INSERT INTO departamentos(departamento, foto) VALUES (?,?)";

    db.query(ssql,[dadosDepartamento.departamento,dadosDepartamento.foto],function(err,result){
        callback(err,result);
    });
};

function ListarDepartamento(departamento,pagina,callback){
    let filtro = [];
    let ssql = "SELECT * FROM departamentos WHERE 1 ";

    if(departamento?.length > 0){
        
        ssql += "AND departamento LIKE ? ";
        filtro.push('%'+departamento+'%');
    }

    ssql += " ORDER BY departamento DESC ";

    if(pagina){
        ssql += "LIMIT ?,? ";
        filtro.push((pagina-1)*10);
        filtro.push(10);
    }

    db.query(ssql, filtro,function(err,result){
        callback(err,result);
    });
};

function AtualizaEmpresa(dadosDepartamento,id_departamento,callback){
    let ssql = "UPDATE departamentos SET departamento=?,foto=? WHERE id_departamento = ?";

    db.query(ssql,[dadosDepartamento.departamento,dadosDepartamento.foto,id_departamento],function(err,result){
        callback(err,result);
    });
};

export default {InserirDepartamento,ListarDepartamento,AtualizaEmpresa};