import {db} from '../config/database.js';
import bcrypt from 'bcryptjs';

function Login(email,callback){
    let ssql = "SELECT C.*, E.* FROM clientes C INNER JOIN enderecos E ON C.id_cliente = E.id_cliente WHERE C.email = ?";

    db.query(ssql,[email],function(err,result){
        callback(err,result);
    });
};

function Inserir(dadosCliente,callback){
    db.getConnection(function(err,conn){
        conn.beginTransaction(async function(err){
            let ssql = "INSERT INTO clientes(razao_social, fantasia, pessoa_fj, cpfcnpj, inscricao_estadual, telefone, site, email, senha, ativo, data_cadastro,cliente_assas) VALUES (?,?,?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP(),?)";

            const criptSenha = await bcrypt.hash(dadosCliente.senha,10)

            conn.query(ssql,[dadosCliente.razao,dadosCliente.fantasia,dadosCliente.pessoa,dadosCliente.cnpj,dadosCliente.ie,dadosCliente.telefone,dadosCliente.site,dadosCliente.email,criptSenha,1,dadosCliente.assas], function(err,result){
                    if(err){
                        conn.rollback();
                        callback(err,result);
                    }else{
                        const id_cliente = result.insertId;

                        ssql = "INSERT INTO enderecos(id_cliente, cep, endereco, numero, bairro, complemento, ibge, cidade, uf, padrao) VALUES (?,?,?,?,?,?,?,?,?,'S')";

                        conn.query(ssql,[id_cliente,dadosCliente.cep,dadosCliente.endereco,
                            dadosCliente.nro,dadosCliente.bairro,dadosCliente.complemento,
                            dadosCliente.ibge,dadosCliente.cidade,dadosCliente.uf],function(err,result){
                            if(err){
                                conn.rollback();
                            }else{
                                conn.commit();
                                
                            }
                            conn.release();
                            callback(err,{id_cliente});
                        });
                    }
            })

        });
    })
};

function ListarID(id_cliente,callback){
    let ssql = "SELECT * ";
    ssql+="FROM clientes ";
    ssql+="WHERE id_cliente = ?";

    db.query(ssql,[id_cliente],function(err,result){
        callback(err,result);
    });
};

function Editar(id_cliente,dadosCliente,callback){
    let ssql = "UPDATE clientes SET razao_social=?,fantasia=?,telefone=?,site=?,email=?,ativo=? WHERE id_cliente = ?";

    db.query(ssql,[dadosCliente.razao,dadosCliente.fantasia,dadosCliente.telefone,dadosCliente.site,dadosCliente.email,dadosCliente.ativo,id_cliente],function(err,result){
        callback(err,result);
    });
};

function ListarEnderecos(id_cliente, cod_cidade, id_endereco, callback){
    let filtro = [];

    let ssql = "SELECT * FROM enderecos WHERE id_cliente = ? ";

    filtro.push(id_cliente);

    if(cod_cidade){
        ssql+="AND ibge = ? ";
        filtro.push(cod_cidade);
    }

    if(id_endereco){
        ssql+=' AND id_endereco = ?';
        filtro.push(id_endereco);
    }

    ssql+="ORDER BY endereco ASC";

    db.query(ssql,filtro,function(err,result){
        callback(err,result);
    });
};

function InserirEndereco(id_cliente,dadosEnd,callback){
    let ssql = "INSERT INTO enderecos(id_cliente, cep, endereco, numero, bairro, complemento, ibge, cidade, uf, padrao) VALUES (?,?,?,?,?,?,?,?,?,?)";

    db.query(ssql,[id_cliente,dadosEnd.cep,dadosEnd.endereco,dadosEnd.nro,dadosEnd.bairro,dadosEnd.complemento,dadosEnd.ibge,dadosEnd.cidade,dadosEnd.uf,dadosEnd.padrao],function(err,result){
        callback(err,result);
    });
};

function EditarEndereco(id_cliente,id_endereco,dadosEnd,callback){
    let ssql = "UPDATE enderecos SET cep=?,endereco=?,numero=?,bairro=?,complemento=?,ibge=?,cidade=?,uf=? WHERE id_endereco = ? AND id_cliente = ?";

    db.query(ssql,[dadosEnd.cep,dadosEnd.endereco,dadosEnd.nro,dadosEnd.bairro,dadosEnd.complemento,dadosEnd.ibge,dadosEnd.cidade,dadosEnd.uf,id_endereco,id_cliente],function(err,result){
        callback(err,result);
    });
};

function ExcluirEndereco(id_endereco,id_cliente,callback){
    let ssql = "DELETE FROM enderecos WHERE id_endereco = ? AND id_cliente = ?";

    db.query(ssql,[id_endereco,id_cliente],function(err,result){
        callback(err,result);
    });
};

function EnderecoPadrao(id_endereco,id_cliente,callback){
    db.getConnection(function(err,conn){
        conn.beginTransaction(async function(err){
            let ssql = "UPDATE enderecos SET padrao='N' WHERE id_cliente = ?";

            conn.query(ssql,[id_cliente], function(err,result){
                    if(err){
                        conn.rollback();
                        callback(err,result);
                    }else{

                        ssql = "UPDATE enderecos SET padrao='S' WHERE id_endereco = ? AND id_cliente = ?";

                        conn.query(ssql,[id_endereco,id_cliente],function(err,result){
                            if(err){
                                conn.rollback();
                            }else{
                                conn.commit();
                                
                            }
                            conn.release();
                            callback(err,{id_endereco});
                        });
                    }
            })

        });
    })
};

function EditarClienteAssas(id_cliente,cliente_assas,callback){

    let ssql = "UPDATE clientes SET cliente_assas=? WHERE id_cliente = ?";

    db.query(ssql,[cliente_assas,id_cliente],function(err,result){
        callback(err,result);
    });
};

function CadastrarCartao(id_cliente,dadosCartao,callback){

    let ssql = "INSERT INTO cartoes(id_cliente, nro, bandeira, token, apelido) VALUES (?,?,?,?,?)";

    db.query(ssql,[id_cliente,dadosCartao.nro,dadosCartao.bandeira,dadosCartao.token,dadosCartao.apelido],function(err,result){
        callback(err,result);
    });
}

function ListarCartoes(id_cliente,callback){

    let ssql = "SELECT * FROM cartoes WHERE id_cliente = ? ";

    ssql+="ORDER BY id_cartao DESC";

    db.query(ssql,[id_cliente],function(err,result){
        callback(err,result);
    });
};

export default {Login,Inserir,ListarID,Editar, ListarEnderecos,InserirEndereco, EditarEndereco, ExcluirEndereco,EnderecoPadrao,EditarClienteAssas,CadastrarCartao,ListarCartoes};