import modelProfissional from "../models/model.profissionais.js";
import {createJWT} from "../config/token.js";
import bcrypt from 'bcryptjs';

function InserirProfissional(req,res){
    modelProfissional.InserirProfissional(req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            let resultado = result;
            resultado["token"] = createJWT(result.id_profissional);
            res.status(201).json({id_profissional:result.insertId});
        }
    });
}

function LoginProfissional(req,res){
    modelProfissional.LoginProfissional(req.body.email, async function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            if(result.length == 0){
                res.status(401).send('E-mail ou senha inválida');
            }else{

                if(await bcrypt.compare(req.body.senha, result[0].senha)){
                    let resultado = result[0];
                    resultado["token"] = createJWT(result[0].id_profissional);
                    delete resultado.senha;
                    res.status(200).json(resultado);
                }else{
                    res.status(401).send('E-mail ou senha inválida');
                }
            }
        }
        
    });
    
    
};

function ListarProfissional(req,res){
    modelProfissional.ListarProfissionais(req.query.id_servico,req.query.id_profissional,req.query.profissional,req.query.regiao,req.query.pagina,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function EditarProfissional(req,res){
    modelProfissional.EditarProfissional(req.id,req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_profissional : req.id});
        }
    })
};

function EditarSenha(req,res){
    modelProfissional.AtualizarSenha(req.id,req.body.senha,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_profissional : req.id});
        }
    })
};

function InserirVitrine(req,res){
    modelProfissional.InserirVitrine(req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            let resultado = result;
            res.status(201).json({id_vitrine:result.insertId});
        }
    });
}

function ListarVitrine(req,res){
    modelProfissional.ListarVitrine(req.params.id_profissional,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function ListarServicos(req,res){

    modelProfissional.ListarServicos(req.query.servico,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

export default {InserirProfissional,LoginProfissional,ListarProfissional,EditarProfissional,EditarSenha,InserirVitrine,ListarVitrine,ListarServicos}; 