import modelProdutos from "../models/model.produtos.js";

function InserirUnidades(req,res){
    modelProdutos.InserirUnidade(req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            let resultado = result;
            res.status(201).json({id_unidade:result.insertId});
        }
    });
}

function ListarUnidades(req,res){
    modelProdutos.ListarUnidade(req.query.unidade,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function AtualizarUnidades(req,res){
    modelProdutos.AtualizarUnidade(req.body,req.params.id_unidade,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_unidade:req.params.id_unidade});
        }
    });
}

function InserirProduto(req,res){
    modelProdutos.InserirProduto(req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            let resultado = result;
            res.status(201).json({id_produto:result.insertId});
        }
    });
}

function ListarProduto(req,res){
    modelProdutos.ListarProduto(req.query.produto,req.query.id_empresa,req.query.id_fornecedor,req.query.id_departamento,req.query.cidade,req.query.id_produto,req.query.pagina,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function AtualizarProduto(req,res){
    modelProdutos.AtualizarProduto(req.body,req.params.id_produto,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_produto:req.params.id_produto});
        }
    });
}

function ListarVariacoes(req,res){
    modelProdutos.ListarVariacoes(req.query.id_produto,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function InserirTipoVariacao(req,res){
    modelProdutos.InserirTipoVariacao(req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            let resultado = result;
            res.status(201).json({id_variacao:result.insertId});
        }
    });
}

function ListarTipoVariacoes(req,res){
    modelProdutos.ListarTipoVariacoes(function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function ListarmaisVendidos(req,res){
    let dataInicio, dataFim;
    const hoje = new Date();

    switch (req.params.periodo) {
    case 'mes':
        dataInicio = new Date(hoje.getFullYear(), hoje.getMonth(), 1);
        dataFim = new Date(hoje.getFullYear(), hoje.getMonth() + 1, 0); // último dia do mês
        break;
    case 'ano':
        dataInicio = new Date(hoje.getFullYear(), 0, 1);
        dataFim = new Date(hoje.getFullYear(), 11, 31);
        break;
    default:
        dataInicio = hoje;
        dataFim = hoje;
    }

    modelProdutos.ListarmaisVendidos(req.params.id_empresa,dataInicio,dataFim,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

export default {InserirUnidades,ListarUnidades,AtualizarUnidades,InserirProduto,ListarProduto,AtualizarProduto,ListarVariacoes,InserirTipoVariacao,ListarTipoVariacoes,ListarmaisVendidos}; 