import modelPedidos from "../models/model.pedidos.js";

function Inserir(req,res){
    modelPedidos.Inserir(req.id,req.body,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_pedido:result.insertId});
        }
    });
}

function Listar(req,res){
    modelPedidos.Listar(req.id,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function ListarPedidoEmpresa(req,res){
    modelPedidos.ListarEmpresa(req.id,req.query.pedido,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function ListarItens(req,res){
    modelPedidos.ListarItens(req.params.id_pedido,req.query.pagina,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function AtualizarStatus(req,res){
    modelPedidos.AtualizarStatus(req.body.status,req.params.id_pedido,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_pedido:req.params.id_pedido});
        }
    });
}

function AtualizarStatusCancelamento(req,res){
    modelPedidos.AtualizarStatusCancelamento(req.body.motivo,req.params.id_pedido,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_pedido:req.params.id_pedido});
        }
    });
}

function AvaliarPedido(req,res){
    modelPedidos.AvaliarPedido(req.body.avaliacao,req.params.id_pedido,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_pedido:req.params.id_pedido});
        }
    });
}

function AvaliarItens(req,res){
    modelPedidos.AvaliarItens(req.body.avaliacao,req.params.id_item,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_item:req.params.id_item});
        }
    });
}

function ListarPedidoCliente(req,res){

    modelPedidos.ListarPedidoCliente(req.query.id_cliente,req.params.id_pedido,req.id,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result[0]);
        }
    });
}

function AtribuirEntregador(req,res){
    modelPedidos.AbrituirEntregador(req.params.id_pedido,req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_pedido:result.insertId});
        }
    });
}

function ListarPedidoEntregador(req,res){
    modelPedidos.ListarEntregador(req.params.id_pedido,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result[0]);
        }
    });
}

function ListarPedidosRecentes(req, res) {
  let dataInicio, dataFim;
  const hoje = new Date();

  switch (req.query.periodo) {
    case 'mes':
      dataInicio = new Date(hoje.getFullYear(), hoje.getMonth(), 1);
      dataFim = new Date(hoje.getFullYear(), hoje.getMonth() + 1, 0);
      break;
    case 'ano':
      dataInicio = new Date(hoje.getFullYear(), 0, 1);
      dataFim = new Date(hoje.getFullYear(), 11, 31);
      break;
    default:
      dataInicio = new Date(hoje.toDateString());
      dataFim = new Date(hoje.toDateString());
  }

  modelPedidos.ListarPedidosRecentes(req.query.id_empresa, dataInicio, dataFim, function (err, result) {
    if (err) {
      res.status(500).send(err);
    } else {
      res.status(200).json(result);
    }
  });
}

function ListarVendas(req, res) {
let dataInicio, dataFim;
const hoje = new Date();

switch (req.query.periodo) {
  case 'mes':
    dataInicio = new Date(hoje.getFullYear(), hoje.getMonth(), 1);
    dataFim = new Date(hoje.getFullYear(), hoje.getMonth() + 1, 0);
    break;
  case 'ano':
    dataInicio = new Date(hoje.getFullYear(), 0, 1);
    dataFim = new Date(hoje.getFullYear(), 11, 31);
    break;
  default:
    dataInicio = new Date(hoje.toDateString());
    dataFim = new Date(hoje.toDateString());
}


// 🗓️ Calcula intervalo em dias
const dias = Math.ceil((dataFim - dataInicio) / (1000 * 60 * 60 * 24)) + 1;

// 🕰️ Período anterior com mesmo intervalo
const dataInicioAnterior = new Date(dataInicio);
dataInicioAnterior.setDate(dataInicio.getDate() - dias);

const dataFimAnterior = new Date(dataFim);
dataFimAnterior.setDate(dataFim.getDate() - dias);

// 🔍 Primeiro: dados do período atual
modelPedidos.ListarVendas(req.query.id_empresa, dataInicio, dataFim, function (err, resultAtual) {
  if (err) return res.status(500).send(err);

  const totalAtual = resultAtual[0]?.total_vendas || 0;

  // 🔁 Segundo: dados do período anterior
  modelPedidos.ListarVendas(req.query.id_empresa, dataInicioAnterior, dataFimAnterior, function (err2, resultAnterior) {
    if (err2) return res.status(500).send(err2);

    const totalAnterior = resultAnterior[0]?.total_vendas || 0;

    const variacao = totalAnterior > 0
      ? ((totalAtual - totalAnterior) / totalAnterior) * 100
      : totalAtual > 0 ? 100 : 0;

    const positivo = totalAtual >= totalAnterior;

    res.status(200).json({
      valor: totalAtual,
      percentual: Math.abs(variacao.toFixed(1)) + '%',
      mensagem: positivo ? 'de aumento' : 'de queda',
      positivo
    });
  });
});
}

function ListarClientes(req, res) {
let dataInicio, dataFim;
const hoje = new Date();

switch (req.query.periodo) {
  case 'mes':
    dataInicio = new Date(hoje.getFullYear(), hoje.getMonth(), 1);
    dataFim = new Date(hoje.getFullYear(), hoje.getMonth() + 1, 0);
    break;
  case 'ano':
    dataInicio = new Date(hoje.getFullYear(), 0, 1);
    dataFim = new Date(hoje.getFullYear(), 11, 31);
    break;
  default:
    dataInicio = new Date(hoje.toDateString());
    dataFim = new Date(hoje.toDateString());
}


// 🗓️ Calcula intervalo em dias
const dias = Math.ceil((dataFim - dataInicio) / (1000 * 60 * 60 * 24)) + 1;

// 🕰️ Período anterior com mesmo intervalo
const dataInicioAnterior = new Date(dataInicio);
dataInicioAnterior.setDate(dataInicio.getDate() - dias);

const dataFimAnterior = new Date(dataFim);
dataFimAnterior.setDate(dataFim.getDate() - dias);

// 🔍 Primeiro: dados do período atual
modelPedidos.ListarClientes(req.query.id_empresa, dataInicio, dataFim, function (err, resultAtual) {
  if (err) return res.status(500).send(err);

  const totalAtual = resultAtual[0]?.total_vendas || 0;

  // 🔁 Segundo: dados do período anterior
  modelPedidos.ListarClientes(req.query.id_empresa, dataInicioAnterior, dataFimAnterior, function (err2, resultAnterior) {
    if (err2) return res.status(500).send(err2);

    const totalAnterior = resultAnterior[0]?.total_vendas || 0;

    const variacao = totalAnterior > 0
      ? ((totalAtual - totalAnterior) / totalAnterior) * 100
      : totalAtual > 0 ? 100 : 0;

    const positivo = totalAtual >= totalAnterior;

    res.status(200).json({
      valor: totalAtual,
      percentual: Math.abs(variacao.toFixed(1)) + '%',
      mensagem: positivo ? 'de aumento' : 'de queda',
      positivo
    });
  });
});
}

function NotificacaoEmpresa(req,res){
    modelPedidos.NotificacaoEmpresa(req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_notificação:result.insertId});
        }
    });
}

function NotificacaoMostrar(req,res){
    modelPedidos.NotificacaoMostrar(req.body.id_empresa,req.body.tipo,req.body.pagina,req.body.total,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

export default {Inserir,Listar,ListarPedidoEmpresa,ListarItens,AtualizarStatus,AtualizarStatusCancelamento,AvaliarPedido,AvaliarItens,ListarPedidoCliente,AtribuirEntregador,ListarPedidoEntregador,ListarPedidosRecentes,ListarVendas,ListarClientes,NotificacaoEmpresa,NotificacaoMostrar}; 