import modelMarcas from "../models/model.marcas.js";

function InserirMarca(req,res){
    modelMarcas.InserirMarca(req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            let resultado = result;
            res.status(201).json({id_marca:result.insertId});
        }
    });
}

function ListarMarca(req,res){
    modelMarcas.ListarMarca(req.query.marca,req.id,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function AtualizarMarca(req,res){
    modelMarcas.AtualizarMarca(req.body,req.params.id_marca,req.id,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_marca:req.params.id_marca});
        }
    });
}

function BuscarMarca(req,res){

    modelMarcas.BuscarMarca(req.params.id_marca,req.id,function(err, result){

        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result[0]);
        }
    });
}

export default {InserirMarca,ListarMarca,AtualizarMarca,BuscarMarca}; 