import modelEntregador from "../models/model.entregadores.js";
import {createJWT} from "../config/token.js";
import bcrypt from 'bcryptjs';

function InserirEntregador(req,res){
    modelEntregador.InserirEntregador(req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            let resultado = result;
            resultado["token"] = createJWT(result.id_entregador);
            res.status(201).json({id_entregador:result.insertId});
        }
    });
}

function LoginEntregador(req,res){
    modelEntregador.LoginEntregador(req.body.email, async function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            if(result.length == 0){
                res.status(401).send('E-mail ou senha inválida');
            }else{

                if(await bcrypt.compare(req.body.senha, result[0].senha)){
                    let resultado = result[0];
                    resultado["token"] = createJWT(result[0].id_entregador);
                    delete resultado.senha;
                    res.status(200).json(resultado);
                }else{
                    res.status(401).send('E-mail ou senha inválida');
                }
            }
        }
        
    });
    
    
};

function ListarID(req,res){
    // if(req.params.id_entregador != req.id){
    //     return res.status(401).json({erro:"Operação não permitida(Obter informações de outro usuário)"});
    // }
    modelEntregador.ListarID(req.params.id_entregador,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result[0]);
        }
    });
};

function EditarEntregador(req,res){
    modelEntregador.EditarEntregador(req.id,req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_entregador : req.id});
        }
    })
};

function EditarVeiculo(req,res){
    modelEntregador.EditarVeiculo(req.id,req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_entregador : req.id});
        }
    })
};

function EditarFoto(req,res){
    modelEntregador.EditarFoto(req.id,req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_entregador : req.id});
        }
    })
};

function EditarSenha(req,res){
    modelEntregador.AtualizarSenha(req.id,req.body.senha,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_entregador : req.id});
        }
    })
};

function ListarPedidoEntrega(req,res){

    modelEntregador.ListarPedidoEntrega(req.params.id_pedido,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result[0]);
        }
    });
};

function ListarModalidade(req,res){

    modelEntregador.ListarModalidade(function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
};

function InserirPedidoEntrega(req,res){

    modelEntregador.InserirPedidoEntrega(req.params.id_pedido,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_entrega:result.insertId});
        }
    });
};

function AtualizarPedidoEntregaEntregador(req,res){

    modelEntregador.AtualizarPedidoEntregaEntregador(req.params.id_pedido,req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_pedido:req.params.id_pedido});
        }
    });
};

function AtualizarCoordenadas(req,res){

    modelEntregador.AtualizarCoordenadas(req.params.id_pedido,req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_pedido:req.params.id_pedido});
        }
    });
};

export default {InserirEntregador,LoginEntregador,ListarID,EditarEntregador,EditarVeiculo,EditarFoto,EditarSenha,ListarPedidoEntrega,ListarModalidade,InserirPedidoEntrega,AtualizarPedidoEntregaEntregador,AtualizarCoordenadas}; 