import modelEmpresa from "../models/model.empresas.js";
import {createJWT} from "../config/token.js";
import bcrypt from 'bcryptjs';

function InserirEmpresa(req,res){
    modelEmpresa.Inserir(req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            let resultado = result;
            resultado["token"] = createJWT(result.id_empresa);
            res.status(201).json({id_empresa:result.insertId});
        }
    });
}

function LoginEmpresa(req,res){
    modelEmpresa.LoginEmpresa(req.body.email, async function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            if(result.length == 0){
                res.status(401).send('E-mail ou senha inválida');
            }else{

                if(await bcrypt.compare(req.body.senha, result[0].senha)){
                    let resultado = result[0];
                    resultado["token"] = createJWT(result[0].id_empresa);
                    delete resultado.senha;
                    res.status(200).json(resultado);
                }else{
                    res.status(401).send('E-mail ou senha inválida');
                }
            }
        }
        
    });
    
    
};

function AtualizaEmpresaEmpresa(req,res){
    modelEmpresa.AtualizaEmpresa(req.body,req.params.id_empresa,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            let resultado = result;
            res.status(200).json(resultado);
        }
    });
    
    
};

function ListarEmpresa(req,res){
    modelEmpresa.ListarEmpresa(req.query.ibge,req.query.empresa,req.query.id_empresa,req.query.departamento,req.query.pagina,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        } 
    });
}

function ListarEmpresaFvoritas(req,res){
    modelEmpresa.ListarEmpresaFavoritas(req.query.ibge,req.query.empresa,req.query.id_empresa,req.query.departamento,req.query.pagina,req.id,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        } 
    });
}

function ListarFavoritos(req,res){
    modelEmpresa.ListarFavoritos(req.id,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function InserirFavorito(req,res){
    modelEmpresa.InserirFavorito(req.id,req.body.id_empresa,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_favorito:result.insertId});
        }
    });
}

function ExcluirFavorito(req,res){
    modelEmpresa.ExcluirFavorito(req.params.id_favorito,req.id,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_favorito:req.params.id_favorito});
        }
    });
}

function InserirInteresse(req, res) {
  const dados = req.body;

  modelEmpresa.InserirInteresse(dados, function (err, result) {
    if (err) {
      res.status(500).json({ erro: 'Erro ao registrar interesse', detalhes: err });
    } else {
      res.status(201).json({ sucesso: true, id: result.insertId });
    }
  });
}

function BuscarCNAE(req,res){
    modelEmpresa.BuscarCNAE(req.query.descricao,req.query.pagina,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        } 
    });
}

export default {InserirEmpresa,LoginEmpresa,AtualizaEmpresaEmpresa,ListarFavoritos,InserirFavorito,ExcluirFavorito,ListarEmpresa,ListarEmpresaFvoritas,InserirInteresse,BuscarCNAE}; 