import modelDestaque from "../models/model.destaques.js";

function InserirEmpresaDestaque(req,res){
    modelDestaque.InserirEmpresaDestaque(req.body.id_destaque,req.id,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_destaque:result.insertId});
        }
    });
}

function InserirDestaque(req,res){
    modelDestaque.InserirDestaque(req.body.destaque,req.body.ativo,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_destaque:result.insertId});
        }
    });
}

function ListarDestaquesEmpresa(req,res){
    modelDestaque.ListarDestaquesEmpresa(req.query.cod_cidade,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function ListarDestaques(req,res){
    modelDestaque.ListarDestaques(function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
}

function AtualizarDestaque(req,res){
    modelDestaque.AtualizarDestaque(req.body.destaque,req.body.ativo,req.params.id_destaque,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_destaque:req.params.id_destaque});
        }
    });
}

function AtualizarEmpresaDestaque(req,res){
    modelDestaque.AtualizarEmpresaDestaque(req.body.id_destaque,req.id,req.params.id_destaque,function(err, result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_destaque:req.params.id_destaque});
        }
    });
}

export default {InserirEmpresaDestaque,InserirDestaque,ListarDestaquesEmpresa,ListarDestaques,AtualizarDestaque,AtualizarEmpresaDestaque}; 