import modelClientes from "../models/model.clientes.js";
import {createJWT} from "../config/token.js";
import bcrypt from 'bcryptjs';

function Login(req,res){
    modelClientes.Login(req.body.email, async function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            if(result.length == 0){
                res.status(401).send('E-mail ou senha inválida');
            }else{

                if(await bcrypt.compare(req.body.senha, result[0].senha)){
                    let resultado = result[0];
                    resultado["token"] = createJWT(result[0].id_cliente);
                    delete resultado.senha;
                    res.status(200).json(resultado);
                }else{
                    res.status(401).send('E-mail ou senha inválida');
                }
            }
        }
        
    });
    
    
};

function InserirCliente(req,res){
    modelClientes.Inserir(req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            let resultado = result;
            resultado["token"] = createJWT(result.id_cliente);
            res.status(201).json(resultado);
        }
    });
};

function ListarID(req,res){
    if(req.params.id_cliente != req.id){
        return res.status(401).json({erro:"Operação não permitida(Obter informações de outro usuário)"});
    }
    modelClientes.ListarID(req.params.id_cliente, function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result[0]);
        }
    });
};

function Editar(req,res){
    modelClientes.Editar(req.id,req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_cliente : req.id});
        }
    })
};

function ListarEnderecos(req,res){
    modelClientes.ListarEnderecos(req.query.id_cliente,req.query.cod_cidade,req.query.id_endereco, function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
};

function InserirEndereco(req,res){
    modelClientes.InserirEndereco(req.id,req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_endereco:result.insertId});
        }
    });
};

function EditarEndereco(req,res){
    modelClientes.EditarEndereco(req.id,req.params.id_endereco,req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_endereco:req.params.id_endereco});
        }
    });
};

function ExcluirEndereco(req,res){
    modelClientes.ExcluirEndereco(req.params.id_endereco,req.id,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_endereco:req.params.id_endereco});
        }
    });
};

function EnderecoPadrao(req,res){
    modelClientes.EnderecoPadrao(req.params.id_endereco,req.id,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_endereco:req.params.id_endereco});
        }
    });
};

function EditarClienteAssas(req,res){

    modelClientes.EditarClienteAssas(req.params.id_cliente,req.body.cliente_assas,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json({id_cliente : req.params.id_cliente});
        }
    })
};

function InserirCartao(req,res){

    modelClientes.CadastrarCartao(req.id,req.body,function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(201).json({id_cartao:result.insertId});
        }
    });
};

function ListarCartoes(req,res){
    modelClientes.ListarCartoes(req.id, function(err,result){
        if(err){
            res.status(500).send(err);
        }else{
            res.status(200).json(result);
        }
    });
};

export default {Login,InserirCliente,ListarID,Editar,ListarEnderecos,InserirEndereco,EditarEndereco,ExcluirEndereco,EnderecoPadrao,EditarClienteAssas,InserirCartao,ListarCartoes};