import jwt from "jsonwebtoken";

const secretToken = "MySecretONBUILD";

function createJWT(id){
    const token = jwt.sign({id}, secretToken,{
        expiresIn: 99999999999
    });
    return token;
}

function verifyJWT(req,res,next){
    const authToken = req.headers.authorization;

    if(!authToken){
        return res.status(401).send({message:"Token não informado!"});
    }

    const [str,token] = authToken.split(" ");

    jwt.verify(token,secretToken, function(err,decoded){
        if(err){
            return res.status(401).send({message:"Token inválido!"});
        }else{
            req.id = decoded.id
        }

        next();
    })
}

export {createJWT, verifyJWT};