import express from "express";
import cors from "cors";
import routeEmpresa from "./routers/route.empresa.js";
import routeCliente from "./routers/route.cliente.js";
import routeDepartamento from "./routers/route.departamento.js";
import routeDestaques from "./routers/route.destaque.js";
import routeProduto from "./routers/route.produto.js";
import routeFornecedor from "./routers/route.fornecedor.js";
import routeMarca from "./routers/route.marca.js";
import routePedidos from "./routers/route.pedido.js";
import routeEntregador from "./routers/route.entregador.js";
import routeEntrega from "./routers/route.entrega.js";
import routeProfissional from "./routers/route.profissional.js";

const app = express();
app.use(express.json());
app.use(cors());

//ROTAS
app.use(routeEmpresa);
app.use(routeCliente);
app.use(routeDepartamento);
app.use(routeDestaques);
app.use(routeProduto);
app.use(routeFornecedor);
app.use(routeMarca);
app.use(routePedidos);
app.use(routeEntregador);
app.use(routeEntrega);
app.use(routeProfissional);

app.listen(8088,function(){
    console.log("Servidor rodando na porta 8088");
});
